/*
 * Decompiled with CFR 0.152.
 */
package com.github.oscerd.component.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.schemabuilder.Drop;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.github.oscerd.component.cassandra.CassandraComponent;
import com.github.oscerd.component.cassandra.CassandraEndpoint;
import com.github.oscerd.component.cassandra.CassandraException;
import com.github.oscerd.component.cassandra.CassandraOperations;
import com.github.oscerd.component.cassandra.CassandraOperator;
import com.github.oscerd.component.cassandra.ResultSetFormatStrategies;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraProducer.class);
    private CassandraEndpoint endpoint;

    public CassandraProducer(CassandraEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String body;
        Cluster cassandra = this.endpoint.getCassandraCluster();
        this.defineFormatStrategy();
        if (cassandra == null) {
            cassandra = this.buildCluster(this.endpoint, exchange);
        }
        if ((body = (String)exchange.getIn().getBody()) != null && !ObjectHelper.isEmpty((Object)body)) {
            Session session = cassandra.connect(this.endpoint.getKeyspace());
            try {
                this.executePlainCQLQuery(exchange, body, session);
            }
            catch (Exception e) {
                throw CassandraComponent.wrapInCamelCassandraException(e);
            }
            finally {
                session.close();
                if (!this.endpoint.isExternalCluster()) {
                    cassandra.close();
                }
            }
        }
        CassandraOperations operation = this.endpoint.getOperation();
        Session session = cassandra.connect(this.endpoint.getKeyspace());
        Object header = exchange.getIn().getHeader("CamelCassandraDbOperation");
        if (header != null) {
            LOG.debug("Overriding default operation with operation specified on header: {}", header);
            try {
                operation = header instanceof CassandraOperations ? (CassandraOperations)((Object)ObjectHelper.cast(CassandraOperations.class, (Object)header)) : CassandraOperations.valueOf((String)exchange.getIn().getHeader("CamelCassandraDbOperation", String.class));
            }
            catch (Exception e) {
                throw new CassandraException("Operation specified on header is not supported. Value: " + header, e);
            }
        }
        try {
            this.invokeOperation(operation, exchange, session);
        }
        catch (Exception e) {
            throw CassandraComponent.wrapInCamelCassandraException(e);
        }
        finally {
            session.close();
            if (!this.endpoint.isExternalCluster()) {
                cassandra.close();
            }
        }
    }

    protected void executePlainCQLQuery(Exchange exchange, String query, Session session) {
        ResultSet result = null;
        result = session.execute(query);
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody((Object)result);
    }

    protected void invokeOperation(CassandraOperations operation, Exchange exchange, Session session) throws Exception {
        switch (operation) {
            case selectAll: {
                this.doSelectAll(exchange, CassandraOperations.selectAll, session);
                break;
            }
            case selectAllWhere: {
                this.doSelectWhere(exchange, CassandraOperations.selectAllWhere, session);
                break;
            }
            case selectColumn: {
                this.doSelectColumn(exchange, CassandraOperations.selectColumn, session);
                break;
            }
            case selectColumnWhere: {
                this.doSelectColumnWhere(exchange, CassandraOperations.selectColumnWhere, session);
                break;
            }
            case insert: {
                this.doInsert(exchange, CassandraOperations.insert, session);
                break;
            }
            case update: {
                this.doUpdate(exchange, CassandraOperations.update, session);
                break;
            }
            case deleteColumnWhere: {
                this.doDeleteColumnWhere(exchange, CassandraOperations.deleteColumnWhere, session);
                break;
            }
            case deleteWhere: {
                this.doDeleteWhere(exchange, CassandraOperations.deleteWhere, session);
                break;
            }
            case incrCounter: {
                this.doIncrCounter(exchange, CassandraOperations.incrCounter, session);
                break;
            }
            case decrCounter: {
                this.doDecrCounter(exchange, CassandraOperations.decrCounter, session);
                break;
            }
            case batchOperation: {
                this.doBatchOperation(exchange, CassandraOperations.batchOperation, session);
                break;
            }
            case createIndex: {
                this.doCreateIndex(exchange, CassandraOperations.createIndex, session);
                break;
            }
            case dropIndex: {
                this.doDropIndex(exchange, CassandraOperations.dropIndex, session);
                break;
            }
            default: {
                throw new CassandraException("Operation not supported. Value: " + (Object)((Object)operation));
            }
        }
    }

    protected void doSelectAll(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        if (operation == CassandraOperations.selectAll) {
            Select select = QueryBuilder.select().all().from(this.endpoint.getTable());
            Integer limit = (Integer)exchange.getIn().getHeader("CamelCassandraLimitNumber");
            this.appendLimit(select, limit);
            this.applyConsistencyLevel(select, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)select);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doSelectWhere(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Select.Where select = null;
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        if (operation == CassandraOperations.selectAllWhere) {
            select = QueryBuilder.select().all().from(this.endpoint.getTable()).where();
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        select.and(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        select.and(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        select.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        select.and(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        select.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        select.and(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            String column = (String)exchange.getIn().getHeader("CamelCassandraOrderByColumn");
            String cassOrderDirection = (String)exchange.getIn().getHeader("CamelCassandraOrderDirection");
            Integer limit = (Integer)exchange.getIn().getHeader("CamelCassandraLimitNumber");
            this.appendOrderBy(select, cassOrderDirection, column);
            this.appendLimit(select, limit);
            this.applyConsistencyLevel(select, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)select);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doSelectColumnWhere(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Select.Where select = null;
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        String selectColumn = (String)exchange.getIn().getHeader("CamelCassandraSelectColumn");
        if (operation == CassandraOperations.selectColumnWhere) {
            select = QueryBuilder.select().column(selectColumn).from(this.endpoint.getTable()).where();
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        select.and(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        select.and(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        select.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        select.and(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        select.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        select.and(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            Integer limit = (Integer)exchange.getIn().getHeader("CamelCassandraLimitNumber");
            this.appendLimit(select, limit);
            this.applyConsistencyLevel(select, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)select);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doSelectColumn(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Select select = null;
        String selectColumn = (String)exchange.getIn().getHeader("CamelCassandraSelectColumn");
        if (operation == CassandraOperations.selectColumn) {
            select = QueryBuilder.select().column(selectColumn).from(this.endpoint.getTable());
            Integer limit = (Integer)exchange.getIn().getHeader("CamelCassandraLimitNumber");
            this.appendLimit(select, limit);
            this.applyConsistencyLevel(select, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)select);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(result);
    }

    protected void doInsert(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Insert insert = null;
        HashMap insertingObject = (HashMap)exchange.getIn().getHeader("CamelCassandraInsertObject");
        if (operation == CassandraOperations.insert) {
            insert = QueryBuilder.insertInto((String)this.endpoint.getTable());
            Iterator insertIterator = insertingObject.entrySet().iterator();
            while (insertIterator.hasNext()) {
                Map.Entry element = insertIterator.next();
                insert.value((String)element.getKey(), element.getValue());
                insertIterator.remove();
            }
            this.applyConsistencyLevel(insert, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)insert);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doUpdate(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Update update = null;
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        HashMap updatingObject = (HashMap)exchange.getIn().getHeader("CamelCassandraUpdateObject");
        if (operation == CassandraOperations.update) {
            update = QueryBuilder.update((String)this.endpoint.getTable());
            Iterator updateIterator = updatingObject.entrySet().iterator();
            while (updateIterator.hasNext()) {
                Map.Entry element = updateIterator.next();
                update.with(QueryBuilder.set((String)((String)element.getKey()), element.getValue()));
                updateIterator.remove();
            }
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        update.where(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        update.where(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        update.where(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        update.where(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        update.where(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        update.where(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            this.applyConsistencyLevel(update, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)update);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doDeleteWhere(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Delete.Where delete = null;
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        if (operation == CassandraOperations.deleteWhere) {
            delete = QueryBuilder.delete().all().from(this.endpoint.getTable()).where();
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        delete.and(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        delete.and(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        delete.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        delete.and(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        delete.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        delete.and(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            this.applyConsistencyLevel(delete, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)delete);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doDeleteColumnWhere(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Delete.Where delete = null;
        String deleteColumn = (String)exchange.getIn().getHeader("CamelCassandraDeleteColumn");
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        if (operation == CassandraOperations.deleteColumnWhere) {
            delete = QueryBuilder.delete().column(deleteColumn).from(this.endpoint.getTable()).where();
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        delete.and(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        delete.and(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        delete.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        delete.and(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        delete.and(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        delete.and(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            this.applyConsistencyLevel(delete, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)delete);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doIncrCounter(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Update.Assignments update = null;
        String counterColumn = (String)exchange.getIn().getHeader("CamelCassandraCounterColumn");
        long counterValue = (Long)exchange.getIn().getHeader("CamelCassandraCounterValue");
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        if (operation == CassandraOperations.incrCounter) {
            update = QueryBuilder.update((String)this.endpoint.getTable()).with(QueryBuilder.incr((String)counterColumn, (long)counterValue));
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        update.where(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        update.where(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        update.where(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        update.where(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        update.where(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        update.where(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            this.applyConsistencyLevel(update, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)update);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doDecrCounter(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        Update.Assignments update = null;
        String counterColumn = (String)exchange.getIn().getHeader("CamelCassandraCounterColumn");
        long counterValue = (Long)exchange.getIn().getHeader("CamelCassandraCounterValue");
        String cassOperator = (String)exchange.getIn().getHeader("CamelCassandraOperator");
        CassandraOperator operator = this.getCassandraOperator(cassOperator);
        String whereColumn = (String)exchange.getIn().getHeader("CamelCassandraWhereClause");
        Object whereValue = exchange.getIn().getHeader("CamelCassandraWhereValue");
        if (operation == CassandraOperations.decrCounter) {
            update = QueryBuilder.update((String)this.endpoint.getTable()).with(QueryBuilder.decr((String)counterColumn, (long)counterValue));
            if (whereColumn != null && whereValue != null) {
                switch (operator) {
                    case eq: {
                        update.where(QueryBuilder.eq((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gt: {
                        update.where(QueryBuilder.gt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case gte: {
                        update.where(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lt: {
                        update.where(QueryBuilder.lt((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case lte: {
                        update.where(QueryBuilder.gte((String)whereColumn, (Object)whereValue));
                        break;
                    }
                    case in: {
                        update.where(QueryBuilder.in((String)whereColumn, (List)((List)whereValue)));
                        break;
                    }
                }
            }
            this.applyConsistencyLevel(update, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)update);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doBatchOperation(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        PreparedStatement preparedStatement = null;
        String batchQuery = (String)exchange.getIn().getHeader("CamelCassandraBatchQuery");
        List objectArrayList = (List)exchange.getIn().getHeader("CamelCassandraBatchQueryList");
        if (operation == CassandraOperations.batchOperation && batchQuery != null && objectArrayList != null) {
            preparedStatement = session.prepare(batchQuery);
            BatchStatement batch = new BatchStatement();
            Iterator objectArrayIterator = objectArrayList.iterator();
            while (objectArrayIterator.hasNext()) {
                Object[] objectArray = (Object[])objectArrayIterator.next();
                batch.add((Statement)preparedStatement.bind(objectArray));
                objectArrayIterator.remove();
            }
            this.applyConsistencyLevel(batch, this.endpoint.getConsistencyLevel());
            result = session.execute((Statement)batch);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(this.endpoint.getResultSetFormatStrategy().getResult(result));
    }

    protected void doCreateIndex(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        String columnName = (String)exchange.getIn().getHeader("CamelCassandraIndexColumn");
        String indexName = (String)exchange.getIn().getHeader("CamelCassandraIndexName");
        if (operation == CassandraOperations.createIndex && columnName != null && indexName != null) {
            SchemaStatement sb = SchemaBuilder.createIndex((String)indexName).ifNotExists().onTable(this.endpoint.getKeyspace(), this.endpoint.getTable()).andColumn(columnName);
            result = session.execute((Statement)sb);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(result);
    }

    protected void doDropIndex(Exchange exchange, CassandraOperations operation, Session session) throws Exception {
        ResultSet result = null;
        String indexName = (String)exchange.getIn().getHeader("CamelCassandraIndexName");
        if (operation == CassandraOperations.dropIndex && indexName != null) {
            Drop sb = SchemaBuilder.dropIndex((String)indexName);
            result = session.execute((Statement)sb);
        }
        Message responseMessage = this.prepareResponseMessage(exchange);
        responseMessage.setBody(result);
    }

    private void appendOrderBy(Select.Where select, String orderDirection, String columnName) throws CassandraException {
        if (columnName != null && orderDirection != null) {
            CassandraOperator operator = this.getCassandraOperator(orderDirection);
            if (operator.equals((Object)CassandraOperator.asc)) {
                select.orderBy(new Ordering[]{QueryBuilder.asc((String)columnName)});
            } else {
                select.orderBy(new Ordering[]{QueryBuilder.desc((String)columnName)});
            }
        }
    }

    private void appendLimit(Select.Where select, Integer limit) {
        if (!ObjectHelper.isEmpty((Object)limit)) {
            select.limit(limit.intValue());
        }
    }

    private void appendLimit(Select select, Integer limit) {
        if (!ObjectHelper.isEmpty((Object)limit)) {
            select.limit(limit.intValue());
        }
    }

    private Message prepareResponseMessage(Exchange exchange) {
        Message answer = exchange.getOut();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (boolean)false);
        answer.setBody(exchange.getIn().getBody());
        return answer;
    }

    private Collection<InetAddress> getInetAddress(List<String> addr) throws UnknownHostException {
        HashSet<InetAddress> coll = new HashSet<InetAddress>();
        for (String address : addr) {
            coll.add(InetAddress.getByName(address));
        }
        return coll;
    }

    private CassandraOperator getCassandraOperator(String operator) throws CassandraException {
        CassandraOperator cassOperator = null;
        switch (operator) {
            case "eq": {
                cassOperator = CassandraOperator.eq;
                break;
            }
            case "gt": {
                cassOperator = CassandraOperator.gt;
                break;
            }
            case "gte": {
                cassOperator = CassandraOperator.gte;
                break;
            }
            case "lt": {
                cassOperator = CassandraOperator.lt;
                break;
            }
            case "lte": {
                cassOperator = CassandraOperator.lte;
                break;
            }
            case "in": {
                cassOperator = CassandraOperator.in;
                break;
            }
            case "asc": {
                cassOperator = CassandraOperator.asc;
                break;
            }
            case "desc": {
                cassOperator = CassandraOperator.desc;
                break;
            }
            default: {
                throw new CassandraException("Operator does not exist. Value: " + operator);
            }
        }
        return cassOperator;
    }

    private ConsistencyLevel getConsistencyLevel(String consistencyLevelString) throws CassandraException {
        ConsistencyLevel consistencyLevel = null;
        switch (consistencyLevelString) {
            case "ONE": {
                consistencyLevel = ConsistencyLevel.ONE;
                break;
            }
            case "TWO": {
                consistencyLevel = ConsistencyLevel.TWO;
                break;
            }
            case "THREE": {
                consistencyLevel = ConsistencyLevel.THREE;
                break;
            }
            case "ALL": {
                consistencyLevel = ConsistencyLevel.ALL;
                break;
            }
            case "ANY": {
                consistencyLevel = ConsistencyLevel.ANY;
                break;
            }
            case "QUORUM": {
                consistencyLevel = ConsistencyLevel.QUORUM;
                break;
            }
            case "EACH_QUORUM": {
                consistencyLevel = ConsistencyLevel.EACH_QUORUM;
                break;
            }
            case "LOCAL_QUORUM": {
                consistencyLevel = ConsistencyLevel.LOCAL_QUORUM;
                break;
            }
            case "LOCAL_ONE": {
                consistencyLevel = ConsistencyLevel.LOCAL_ONE;
                break;
            }
            case "SERIAL": {
                consistencyLevel = ConsistencyLevel.SERIAL;
                break;
            }
            case "LOCAL_SERIAL": {
                consistencyLevel = ConsistencyLevel.LOCAL_SERIAL;
                break;
            }
            default: {
                throw new CassandraException("Consistency level does not exist. Value: " + consistencyLevelString);
            }
        }
        return consistencyLevel;
    }

    private Cluster buildCluster(CassandraEndpoint endpoint, Exchange exchange) throws UnknownHostException {
        List contact = (List)exchange.getIn().getHeader("CamelCassandraContactPoints");
        Collection<InetAddress> contactPoints = this.getInetAddress(contact);
        String cassandraPort = (String)exchange.getIn().getHeader("CamelCassandraPort");
        Cluster.Builder builder = cassandraPort == null ? Cluster.builder().addContactPoints(contactPoints) : Cluster.builder().addContactPoints(contactPoints).withPort(Integer.parseInt(cassandraPort));
        if (!ObjectHelper.isEmpty((Object)endpoint.getUsername()) && !ObjectHelper.isEmpty((Object)endpoint.getPassword())) {
            builder.withCredentials(endpoint.getUsername(), endpoint.getPassword());
        }
        Cluster clusterBuilded = builder.build();
        return clusterBuilded;
    }

    private void defineFormatStrategy() {
        if (!ObjectHelper.isEmpty((Object)this.endpoint.getFormat())) {
            new ResultSetFormatStrategies();
            this.endpoint.setResultSetFormatStrategy(ResultSetFormatStrategies.fromName(this.endpoint.getFormat()));
        }
    }

    private <T extends Statement> T applyConsistencyLevel(T statement, String consistencyLevelString) throws CassandraException {
        if (consistencyLevelString != null && !ObjectHelper.isEmpty((Object)consistencyLevelString)) {
            statement.setConsistencyLevel(this.getConsistencyLevel(consistencyLevelString));
        }
        return statement;
    }
}

