/*
 * Decompiled with CFR 0.152.
 */
package com.github.oscerd.component.cassandra;

import com.datastax.driver.core.Cluster;
import com.github.oscerd.component.cassandra.CassandraComponent;
import com.github.oscerd.component.cassandra.CassandraConsumer;
import com.github.oscerd.component.cassandra.CassandraException;
import com.github.oscerd.component.cassandra.CassandraOperations;
import com.github.oscerd.component.cassandra.CassandraProducer;
import com.github.oscerd.component.cassandra.IResultSetFormatStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class CassandraEndpoint
extends DefaultEndpoint {
    private Cluster cassandraCluster;
    private String beanRef;
    private String keyspace;
    private String table;
    private CassandraOperations operation;
    private String host;
    private String port;
    private String pollingQuery;
    private String username;
    private String password;
    private String format = "normalResultSet";
    private String consistencyLevel;
    protected boolean isExternalCluster = false;
    private IResultSetFormatStrategy resultSetFormatStrategy;

    public CassandraEndpoint() {
    }

    public CassandraEndpoint(String uri, CassandraComponent component, String remaining) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        this.validateProducer();
        return new CassandraProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validateConsumer();
        return new CassandraConsumer(this, processor);
    }

    public boolean isSingleton() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.cassandraCluster == null && this.beanRef != null) {
            Object bean = CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.beanRef);
            if (bean instanceof Cluster) {
                this.cassandraCluster = (Cluster)bean;
                this.isExternalCluster = true;
            } else {
                throw new IllegalArgumentException("CQL Bean type should be of type Cluster but was " + bean);
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.isExternalCluster) {
            this.cassandraCluster.close();
        }
        super.doStop();
    }

    public Cluster getCassandraCluster() {
        return this.cassandraCluster;
    }

    public void setCassandraCluster(Cluster cassandraCluster) {
        this.cassandraCluster = cassandraCluster;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPollingQuery() {
        return this.pollingQuery;
    }

    public void setPollingQuery(String pollingQuery) {
        this.pollingQuery = pollingQuery;
    }

    public CassandraOperations getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) throws CassandraException {
        try {
            this.operation = CassandraOperations.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new CassandraException("Operation not supported", e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBeanRef() {
        return this.beanRef;
    }

    public void setBeanRef(String beanRef) {
        this.beanRef = beanRef;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    protected boolean isExternalCluster() {
        return this.isExternalCluster;
    }

    public IResultSetFormatStrategy getResultSetFormatStrategy() {
        return this.resultSetFormatStrategy;
    }

    public void setResultSetFormatStrategy(IResultSetFormatStrategy resultSetFormatStrategy) {
        this.resultSetFormatStrategy = resultSetFormatStrategy;
    }

    private void validateProducer() throws IllegalArgumentException {
        if (ObjectHelper.isEmpty((Object)this.keyspace)) {
            throw new IllegalArgumentException("The parameter keyspace must be specified");
        }
        if (!ObjectHelper.isEmpty((Object)((Object)this.operation)) && (this.operation == CassandraOperations.selectAll || this.operation == CassandraOperations.selectAllWhere || this.operation == CassandraOperations.selectAllWhere || this.operation == CassandraOperations.selectColumn || this.operation == CassandraOperations.selectColumnWhere || this.operation == CassandraOperations.batchOperation || this.operation == CassandraOperations.decrCounter || this.operation == CassandraOperations.deleteColumnWhere || this.operation == CassandraOperations.incrCounter || this.operation == CassandraOperations.insert || this.operation == CassandraOperations.update) && ObjectHelper.isEmpty((Object)this.table)) {
            throw new IllegalArgumentException("The parameter table must be specified, in case of selectAllWhere, selectColumn, selectAllWhere and selectColumnWhere operation");
        }
    }

    private void validateConsumer() throws IllegalArgumentException {
        if (ObjectHelper.isEmpty((Object)this.host) || ObjectHelper.isEmpty((Object)this.keyspace) || ObjectHelper.isEmpty((Object)this.pollingQuery)) {
            throw new IllegalArgumentException("The parameters host, keyspace and pollingQuery must be specified");
        }
    }
}

