/*
 * Decompiled with CFR 0.152.
 */
package com.github.oscerd.component.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.github.oscerd.component.cassandra.CassandraEndpoint;
import com.github.oscerd.component.cassandra.CassandraException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraConsumer.class);

    public CassandraConsumer(CassandraEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public CassandraEndpoint getEndpoint() {
        return (CassandraEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        String host = this.getEndpoint().getHost();
        String[] hostLists = this.splitHost(host);
        String port = this.getEndpoint().getPort();
        String keySpace = this.getEndpoint().getKeyspace();
        String pollingQuery = this.getEndpoint().getPollingQuery();
        Cluster cluster = this.getEndpoint().getCassandraCluster();
        Cluster.Builder builder = hostLists.length == 0 ? Cluster.builder().addContactPoint(host).withPort(Integer.parseInt(port)) : Cluster.builder().addContactPoints(hostLists).withPort(Integer.parseInt(port));
        if (!ObjectHelper.isEmpty((Object)this.getEndpoint().getUsername()) && !ObjectHelper.isEmpty((Object)this.getEndpoint().getPassword())) {
            builder.withCredentials(this.getEndpoint().getUsername(), this.getEndpoint().getPassword());
        }
        cluster = builder.build();
        Session session = cluster.connect(keySpace);
        ResultSet resultSet = null;
        try {
            resultSet = session.execute(pollingQuery);
        }
        catch (Exception e) {
            throw new CassandraException("Error during execution of polling query: " + pollingQuery, e);
        }
        finally {
            session.close();
            if (!this.getEndpoint().isExternalCluster) {
                cluster.close();
            }
        }
        Exchange exchange = this.getEndpoint().createExchange();
        Message message = exchange.getIn();
        this.fillMessage(resultSet, message);
        try {
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error while processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }

    protected void fillMessage(ResultSet resultSet, Message message) {
        message.setBody((Object)resultSet);
    }

    private String[] splitHost(String hostList) {
        String[] hosts = StringUtils.split((String)hostList, (String)",");
        return hosts;
    }
}

