/*
 * Decompiled with CFR 0.152.
 */
package com.github.oscerd.component.cassandra;

import com.github.oscerd.component.cassandra.CassandraEndpoint;
import com.github.oscerd.component.cassandra.CassandraException;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraComponent.class);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CassandraEndpoint endpoint = new CassandraEndpoint(uri, this, remaining);
        this.setProperties((Object)endpoint, parameters);
        if (remaining.startsWith("bean:")) {
            String beanRef = remaining.substring(5);
            endpoint.setBeanRef(beanRef);
        }
        return endpoint;
    }

    public static CassandraException wrapInCamelCassandraException(Throwable t) {
        if (t instanceof CassandraException) {
            return (CassandraException)t;
        }
        return new CassandraException(t);
    }
}

