/*
 * Decompiled with CFR 0.152.
 */
package humanize.text.util;

import com.google.common.collect.Range;
import com.google.common.escape.UnicodeEscaper;
import humanize.text.util.Replacer;
import java.util.ArrayList;
import java.util.Collection;

public class UnicodeInterpolator
extends UnicodeEscaper {
    private final Replacer replacer;
    private final Collection<Range<Integer>> ranges;

    public UnicodeInterpolator(Replacer replacer) {
        this.replacer = replacer;
        this.ranges = new ArrayList<Range<Integer>>();
    }

    public void addRange(int lower, int upper) {
        this.addRange((Range<Integer>)Range.closed((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper)));
    }

    public void addRange(Range<Integer> range) {
        this.ranges.add(range);
    }

    protected char[] escape(int codePoint) {
        for (Range<Integer> range : this.ranges) {
            if (!range.contains((Comparable)Integer.valueOf(codePoint))) continue;
            return this.replacer.replace(Integer.toHexString(codePoint)).toCharArray();
        }
        return Character.toChars(codePoint);
    }
}

