/*
 * Decompiled with CFR 0.152.
 */
package humanize.spi.context;

import humanize.spi.MessageFormat;
import humanize.spi.cache.CacheProvider;
import humanize.spi.context.Context;
import humanize.spi.context.StandardContext;
import humanize.text.MaskFormat;
import humanize.time.PrettyTimeFormat;
import humanize.util.UTF8Control;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;

public class DefaultContext
implements Context,
StandardContext {
    private static final String BUNDLE_LOCATION = "i18n.Humanize";
    private static final String ORDINAL_SUFFIXES = "ordinal.suffixes";
    private static final String TIME_SUFFIXES = "time.suffixes";
    private static final String CURRENCY = "currency";
    private static final String DECIMAL = "decimal";
    private static final String NUMBER = "number";
    private static final String DIGITS = "digits";
    private static final String PERCENT = "percent";
    private static final String DATE_FORMAT = "date";
    private static final String DATE_TIME_FORMAT = "date.time";
    private static final String SIMPLE_DATE = "simple.date";
    private static final String PRETTY_TIME = "pretty.time";
    private static final String MASK = "mask";
    private static final CacheProvider sharedCache = DefaultContext.loadCacheProvider();
    private final CacheProvider localCache = DefaultContext.loadCacheProvider();
    private Locale locale;

    private static CacheProvider loadCacheProvider() {
        ServiceLoader<CacheProvider> ldr = ServiceLoader.load(CacheProvider.class);
        Iterator<CacheProvider> i$ = ldr.iterator();
        if (i$.hasNext()) {
            CacheProvider provider = i$.next();
            return provider;
        }
        throw new RuntimeException("No CacheProvider was found");
    }

    public DefaultContext() {
        this(Locale.getDefault());
    }

    public DefaultContext(Locale locale) {
        this.setLocale(locale);
    }

    @Override
    public String digitStrings(int index) {
        return this.getStringByIndex(DIGITS, index);
    }

    @Override
    public String formatDate(int style, Date value) {
        return this.getDateFormat(style).format(value);
    }

    @Override
    public String formatDateTime(Date date) {
        return this.getDateTimeFormat().format(date);
    }

    @Override
    public String formatDateTime(int dateStyle, int timeStyle, Date date) {
        return this.getDateTimeFormat(dateStyle, timeStyle).format(date);
    }

    @Override
    public String formatDecimal(Number value) {
        return this.getNumberFormat().format(value);
    }

    @Override
    public String formatMessage(String key, Object ... args) {
        MessageFormat fmt = this.getMessageFormat();
        fmt.applyPattern(this.getBundle().getString(key));
        return fmt.render(args);
    }

    @Override
    public String formatRelativeDate(Date reference, Date duration) {
        return this.getPrettyTimeFormat().format(reference, duration);
    }

    @Override
    public String formatRelativeDate(Date reference, Date duration, long precision) {
        return this.getPrettyTimeFormat().format(reference, duration, precision);
    }

    @Override
    public ResourceBundle getBundle() {
        return sharedCache.getBundle(this.locale, new Callable<ResourceBundle>(){

            @Override
            public ResourceBundle call() throws Exception {
                return ResourceBundle.getBundle(DefaultContext.BUNDLE_LOCATION, DefaultContext.this.locale, new UTF8Control());
            }
        });
    }

    @Override
    public DecimalFormat getCurrencyFormat() {
        return sharedCache.getFormat(CURRENCY, this.locale, new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)NumberFormat.getCurrencyInstance(DefaultContext.this.locale);
            }
        });
    }

    @Override
    public DateFormat getDateFormat(final int style) {
        String name = DATE_FORMAT + style;
        return this.localCache.getFormat(name, this.locale, new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return DateFormat.getDateInstance(style, DefaultContext.this.locale);
            }
        });
    }

    @Override
    public DateFormat getDateFormat(final String pattern) {
        return this.localCache.getFormat(SIMPLE_DATE + pattern.hashCode(), this.locale, new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return new SimpleDateFormat(pattern, DefaultContext.this.locale);
            }
        });
    }

    @Override
    public DateFormat getDateTimeFormat() {
        return this.getDateTimeFormat(3, 3);
    }

    @Override
    public DateFormat getDateTimeFormat(final int dateStyle, final int timeStyle) {
        String name = DATE_TIME_FORMAT + dateStyle + timeStyle;
        return this.localCache.getFormat(name, this.locale, new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return DateFormat.getDateTimeInstance(dateStyle, timeStyle, DefaultContext.this.locale);
            }
        });
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return this.localCache.getFormat(DECIMAL, this.locale, new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)DecimalFormat.getInstance(DefaultContext.this.locale);
            }
        });
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public MaskFormat getMaskFormat() {
        return this.localCache.getFormat(MASK, Locale.ROOT, new Callable<MaskFormat>(){

            @Override
            public MaskFormat call() throws Exception {
                return new MaskFormat("");
            }
        });
    }

    @Override
    public String getMessage(String key) {
        return this.getBundle().getString(key);
    }

    @Override
    public MessageFormat getMessageFormat() {
        return new MessageFormat("", this.locale);
    }

    @Override
    public NumberFormat getNumberFormat() {
        return sharedCache.getFormat(NUMBER, this.locale, new Callable<NumberFormat>(){

            @Override
            public NumberFormat call() throws Exception {
                return NumberFormat.getInstance(DefaultContext.this.locale);
            }
        });
    }

    @Override
    public DecimalFormat getPercentFormat() {
        return sharedCache.getFormat(PERCENT, this.locale, new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)NumberFormat.getPercentInstance(DefaultContext.this.locale);
            }
        });
    }

    @Override
    public PrettyTimeFormat getPrettyTimeFormat() {
        return sharedCache.getFormat(PRETTY_TIME, this.locale, new Callable<PrettyTimeFormat>(){

            @Override
            public PrettyTimeFormat call() throws Exception {
                return new PrettyTimeFormat(DefaultContext.this.locale);
            }
        });
    }

    @Override
    public String ordinalSuffix(int index) {
        return this.getStringByIndex(ORDINAL_SUFFIXES, index);
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String timeSuffix(int index) {
        return this.getStringByIndex(TIME_SUFFIXES, index);
    }

    protected String getStringByIndex(String cacheName, int index) {
        return this.getStrings(cacheName)[index];
    }

    protected Collection<String> getStringList(String cacheName) {
        return Arrays.asList(this.getStrings(cacheName));
    }

    protected String[] getStrings(final String cacheName) {
        return sharedCache.getStrings(cacheName, this.locale, new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                return DefaultContext.this.getBundle().getString(cacheName).split(" ");
            }
        });
    }
}

