/*
 * Decompiled with CFR 0.152.
 */
package humanize.time;

import com.google.common.base.Objects;

public class Pace {
    private final long value;
    private final String accuracy;
    private final String timeUnit;
    public static final Pace EMPTY = new Pace(0L, Accuracy.NONE, TimeMillis.SECOND);

    public Pace(long value, Accuracy accuracy, TimeMillis timeUnit) {
        this.value = value;
        this.accuracy = accuracy.name().toLowerCase();
        this.timeUnit = timeUnit.key();
    }

    public String getAccuracy() {
        return this.accuracy;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", this.value).add("accuracy", (Object)this.accuracy).add("timeUnit", (Object)this.timeUnit).toString();
    }

    public static enum TimeMillis {
        SECOND(1000L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L),
        WEEK(604800000L),
        MONTH(2628000000L);

        private long millis;

        private TimeMillis(long millis) {
            this.millis = millis;
        }

        public String key() {
            return this.name().toLowerCase();
        }

        public long millis() {
            return this.millis;
        }
    }

    public static enum Accuracy {
        NONE,
        APROX,
        LESS_THAN;

    }
}

