/*
 * Decompiled with CFR 0.152.
 */
package humanize.time;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.LocaleAware;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.impl.DurationImpl;
import org.ocpsoft.prettytime.impl.ResourcesTimeFormat;
import org.ocpsoft.prettytime.impl.ResourcesTimeUnit;
import org.ocpsoft.prettytime.units.Century;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Decade;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.JustNow;
import org.ocpsoft.prettytime.units.Millennium;
import org.ocpsoft.prettytime.units.Millisecond;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Second;
import org.ocpsoft.prettytime.units.TimeUnitComparator;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public class DurationHelper {
    private static final Map<Locale, DurationDB> dbs = new HashMap<Locale, DurationDB>();

    public static Duration calculateDurantion(Date ref, Date then) {
        return DurationHelper.calculateDurantion(ref, then, Locale.getDefault());
    }

    public static Duration calculateDurantion(Date ref, Date then, List<TimeUnit> timeUnits) {
        long difference = then.getTime() - ref.getTime();
        long absoluteDifference = Math.abs(difference);
        ArrayList<TimeUnit> units = new ArrayList<TimeUnit>(timeUnits);
        DurationImpl result = new DurationImpl();
        for (int i = 0; i < units.size(); ++i) {
            boolean isLastUnit;
            TimeUnit unit = (TimeUnit)units.get(i);
            long millisPerUnit = Math.abs(unit.getMillisPerUnit());
            long quantity = Math.abs(unit.getMaxQuantity());
            boolean bl = isLastUnit = i == units.size() - 1;
            if (0L == quantity && !isLastUnit) {
                quantity = ((TimeUnit)units.get(i + 1)).getMillisPerUnit() / unit.getMillisPerUnit();
            }
            if (millisPerUnit * quantity <= absoluteDifference && !isLastUnit) continue;
            result.setUnit(unit);
            if (millisPerUnit > absoluteDifference) {
                result.setQuantity(0L > difference ? -1L : 1L);
            } else {
                result.setQuantity(difference / millisPerUnit);
            }
            result.setDelta(difference - result.getQuantity() * millisPerUnit);
            break;
        }
        return result;
    }

    public static Duration calculateDurantion(Date ref, Date then, Locale locale) {
        return DurationHelper.calculateDurantion(ref, then, DurationHelper.getDB(locale).getUnits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DurationDB getDB(Locale locale) {
        if (!dbs.containsKey(locale)) {
            Map<Locale, DurationDB> map = dbs;
            synchronized (map) {
                dbs.put(locale, new DurationDB(locale));
            }
        }
        return dbs.get(locale);
    }

    public static class DurationDB {
        private final Map<TimeUnit, TimeFormat> units = new LinkedHashMap<TimeUnit, TimeFormat>();
        private final Locale locale;

        public DurationDB(Locale locale) {
            this.locale = locale;
            this.addUnit((ResourcesTimeUnit)new JustNow());
            this.addUnit((ResourcesTimeUnit)new Millisecond());
            this.addUnit((ResourcesTimeUnit)new Second());
            this.addUnit((ResourcesTimeUnit)new Minute());
            this.addUnit((ResourcesTimeUnit)new Hour());
            this.addUnit((ResourcesTimeUnit)new Day());
            this.addUnit((ResourcesTimeUnit)new Week());
            this.addUnit((ResourcesTimeUnit)new Month());
            this.addUnit((ResourcesTimeUnit)new Year());
            this.addUnit((ResourcesTimeUnit)new Decade());
            this.addUnit((ResourcesTimeUnit)new Century());
            this.addUnit((ResourcesTimeUnit)new Millennium());
        }

        public void addUnit(ResourcesTimeUnit unit) {
            this.registerUnit((TimeUnit)unit, (TimeFormat)new ResourcesTimeFormat(unit));
        }

        public List<TimeUnit> clearUnits() {
            List<TimeUnit> result = this.getUnits();
            this.units.clear();
            return result;
        }

        public List<TimeUnit> getUnits() {
            ArrayList<TimeUnit> result = new ArrayList<TimeUnit>(this.units.keySet());
            Collections.sort(result, new TimeUnitComparator());
            return Collections.unmodifiableList(result);
        }

        public void registerUnit(TimeUnit unit, TimeFormat format) {
            Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (Object)"Unit to register must not be null.");
            Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Format to register must not be null.");
            this.units.put(unit, format);
            if (unit instanceof LocaleAware) {
                ((LocaleAware)unit).setLocale(this.locale);
            }
            if (format instanceof LocaleAware) {
                ((LocaleAware)format).setLocale(this.locale);
            }
        }
    }
}

