/*
 * Decompiled with CFR 0.152.
 */
package humanize.text;

import humanize.spi.FormatProvider;
import humanize.text.FormatFactory;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class MaskFormat
extends Format
implements FormatProvider {
    private static final long serialVersionUID = -2072270263539296713L;
    private static final char DEFAULT_PLACEHOLDER = '_';
    private String mask;
    private char placeholder;

    public static FormatFactory factory() {
        return new FormatFactory(){

            @Override
            public Format getFormat(String name, String args, Locale locale) {
                return new MaskFormat(args);
            }
        };
    }

    public static String format(String mask, String str) {
        return MaskFormat.format(mask, str, '_');
    }

    public static String format(String mask, String str, char placeholder) {
        return new MaskFormat(mask, placeholder).format(str);
    }

    public static String parse(String mask, String source) throws ParseException {
        return MaskFormat.parse(mask, source, '_');
    }

    public static String parse(String mask, String source, char placeholder) throws ParseException {
        return new MaskFormat(mask, placeholder).parse(source);
    }

    public MaskFormat() {
    }

    public MaskFormat(String mask) {
        this(mask, '_');
    }

    public MaskFormat(String mask, char placeholder) {
        this.mask = mask;
        this.placeholder = placeholder;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return null;
        }
        return toAppendTo.append(this.format(obj.toString()));
    }

    public String format(String str) {
        int i;
        if (this.isEmptyInput(this.mask, str)) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        int msgIndex = 0;
        for (i = 0; i < this.mask.length(); ++i) {
            char maskChar = this.mask.charAt(i);
            boolean isPlaceHolder = this.isPlaceholder(maskChar);
            if (!isPlaceHolder && !this.isDeleteholder(maskChar)) {
                result.append(this.isEscapeChar(maskChar) ? this.mask.charAt(++i) : maskChar);
                continue;
            }
            if (isPlaceHolder) {
                result.append(str.charAt(msgIndex));
            }
            if (++msgIndex == str.length()) break;
        }
        while (++i < this.mask.length()) {
            result.append(this.mask.charAt(i));
        }
        return result.toString();
    }

    @Override
    public FormatFactory getFactory() {
        return MaskFormat.factory();
    }

    @Override
    public String getFormatName() {
        return "mask";
    }

    public String getMask() {
        return this.mask;
    }

    public char getPlaceholder() {
        return this.placeholder;
    }

    public String parse(String source) throws ParseException {
        return this.parse(source, null);
    }

    public String parse(String source, ParsePosition pos) throws ParseException {
        if (this.isEmptyInput(this.mask, source)) {
            return source;
        }
        StringBuilder sb = new StringBuilder(this.mask.length());
        for (int i = 0; i < this.mask.length() && i < source.length(); ++i) {
            char maskChar = this.mask.charAt(i);
            if (this.isPlaceholder(maskChar)) {
                sb.append(source.charAt(i));
                continue;
            }
            if (this.isEscapeChar(maskChar) || maskChar == source.charAt(i)) continue;
            throw new ParseException(String.format("Error parsing String: '%s' at %d", source, i), i);
        }
        return sb.toString();
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object result = this.parseObject(source, pos);
        if (pos.getErrorIndex() >= 0) {
            throw new ParseException("Format.parseObject(String) failed", pos.getErrorIndex());
        }
        return result;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        try {
            return this.parse(source, pos);
        }
        catch (ParseException e) {
            pos.setIndex(0);
            pos.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public void setPlaceholder(char placeholder) {
        this.placeholder = placeholder;
    }

    private boolean isDeleteholder(char c) {
        return c == '#';
    }

    private boolean isEmptyInput(String mask, String str) {
        return mask == null || mask.length() == 0 || str == null || str.length() == 0;
    }

    private boolean isEscapeChar(char c) {
        return c == '\\';
    }

    private boolean isPlaceholder(char c) {
        return c == this.placeholder;
    }
}

