/*
 * Decompiled with CFR 0.152.
 */
package humanize.spi;

import humanize.spi.FormatProvider;
import humanize.text.ExtendedMessageFormat;
import humanize.text.FormatFactory;
import java.text.FieldPosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;

public class MessageFormat
extends ExtendedMessageFormat {
    private static final long serialVersionUID = -5384364921909539710L;
    private static final Map<String, FormatFactory> formatFactories = MessageFormat.loadFormatFactories();

    private static Map<String, FormatFactory> loadFormatFactories() {
        HashMap<String, FormatFactory> factories = new HashMap<String, FormatFactory>();
        ServiceLoader<FormatProvider> ldr = ServiceLoader.load(FormatProvider.class);
        for (FormatProvider provider : ldr) {
            MessageFormat.registerProvider(factories, provider);
        }
        return factories;
    }

    private static void registerProvider(Map<String, FormatFactory> factories, FormatProvider provider) {
        String formatName = provider.getFormatName();
        FormatFactory factory = provider.getFactory();
        if (formatName.indexOf(124) > -1) {
            String[] names;
            for (String name : names = formatName.split("\\|")) {
                factories.put(name, factory);
            }
        } else {
            factories.put(formatName, factory);
        }
    }

    public MessageFormat(String pattern) {
        super(pattern, formatFactories);
    }

    public MessageFormat(String pattern, Locale locale) {
        super(pattern, locale, formatFactories);
    }

    public MessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(pattern, locale, registry);
    }

    public MessageFormat(String pattern, Map<String, ? extends FormatFactory> registry) {
        super(pattern, registry);
    }

    public String render(Object ... arguments) {
        return this.format(arguments);
    }

    public StringBuffer render(StringBuffer buffer, Object ... arguments) {
        return this.format(arguments, buffer, (FieldPosition)null);
    }
}

