/*
 * Decompiled with CFR 0.152.
 */
package humanize;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import humanize.spi.Expose;
import humanize.spi.MessageFormat;
import humanize.spi.context.ContextFactory;
import humanize.spi.context.DefaultContext;
import humanize.spi.context.DefaultContextFactory;
import humanize.text.MaskFormat;
import humanize.text.util.InterpolationHelper;
import humanize.text.util.Replacer;
import humanize.time.Pace;
import humanize.time.PrettyTimeFormat;
import humanize.util.Constants;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.BreakIterator;
import java.text.ChoiceFormat;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import javax.xml.bind.DatatypeConverter;

public final class Humanize {
    private static final ContextFactory contextFactory = Humanize.loadContextFactory();
    private static final ThreadLocal<DefaultContext> context = new ThreadLocal<DefaultContext>(){

        @Override
        protected DefaultContext initialValue() {
            return (DefaultContext)contextFactory.createContext();
        }
    };

    public static String binaryPrefix(Number value) {
        return Humanize.prefix(value, 1024, Constants.binPrefixes);
    }

    @Expose
    public static String binaryPrefix(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.binaryPrefix(value);
            }
        }, locale);
    }

    public static String camelize(String text) {
        return Humanize.camelize(text, false);
    }

    public static String camelize(String text, boolean capitalizeFirstChar) {
        StringBuilder sb = new StringBuilder();
        String[] tokens = text.split("[\\.\\s_-]+");
        if (tokens.length < 2) {
            return capitalizeFirstChar ? Humanize.capitalize(text) : text;
        }
        for (String token : tokens) {
            sb.append(Humanize.capitalize(token));
        }
        return capitalizeFirstChar ? sb.toString() : sb.substring(0, 1).toLowerCase(Humanize.currentLocale()) + sb.substring(1);
    }

    public static String camelize(final String text, final boolean capitalizeFirstChar, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.camelize(text, capitalizeFirstChar);
            }
        }, locale);
    }

    @Expose
    public static String camelize(String text, Locale locale) {
        return Humanize.camelize(text, false, locale);
    }

    public static String capitalize(String text) {
        String tmp = text.trim();
        int len = tmp.length();
        if (len == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (!Character.isLetter(tmp.charAt(i))) continue;
            Locale locale = Humanize.currentLocale();
            int lc = i + 1;
            if (i > 0) {
                sb.append(tmp.substring(0, i));
            }
            sb.append(tmp.substring(i, lc).toUpperCase(locale));
            sb.append(tmp.substring(lc).toLowerCase(locale));
            break;
        }
        return sb.length() == 0 ? tmp : sb.toString();
    }

    @Expose
    public static String capitalize(final String text, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.capitalize(text);
            }
        }, locale);
    }

    public static DateFormat dateFormat(String pattern) {
        return context.get().getDateFormat(pattern);
    }

    public static DateFormat dateFormat(final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return Humanize.dateFormat(pattern);
            }
        }, locale);
    }

    @Expose
    public static String decamelize(String words) {
        return Constants.SPLIT_CAMEL.matcher(words).replaceAll(" ");
    }

    public static String decamelize(String words, String replacement) {
        return Constants.SPLIT_CAMEL.matcher(words).replaceAll(replacement);
    }

    public static DecimalFormat decimalFormat(String pattern) {
        DecimalFormat decFmt = context.get().getDecimalFormat();
        decFmt.applyPattern(pattern);
        return decFmt;
    }

    public static DecimalFormat decimalFormat(final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return Humanize.decimalFormat(pattern);
            }
        }, locale);
    }

    public static String duration(Number seconds) {
        return Humanize.duration(seconds, Constants.TimeStyle.STANDARD);
    }

    public static String duration(final Number seconds, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.duration(seconds);
            }
        }, locale);
    }

    public static String duration(Number seconds, Constants.TimeStyle style) {
        int s = seconds.intValue();
        boolean neg = s < 0;
        s = Math.abs(s);
        return style.format(context.get(), neg, s / 3600 % 60, s / 60 % 60, s % 60);
    }

    public static String duration(final Number seconds, final Constants.TimeStyle style, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.duration(seconds, style);
            }
        }, locale);
    }

    public static String fixLength(String text, int charsNum, char paddingChar) {
        return Humanize.fixLength(text, charsNum, paddingChar, false);
    }

    public static String fixLength(String text, int charsNum, char paddingChar, boolean left) {
        Preconditions.checkArgument((charsNum > 0 ? 1 : 0) != 0, (Object)"The number of characters must be greater than zero.");
        String str = text == null ? "" : text;
        String fmt = String.format("%%%ss", left ? charsNum : -charsNum);
        return String.format(fmt, str).substring(0, charsNum).replace(' ', paddingChar);
    }

    public static String format(Locale locale, final String pattern, final Object ... args) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.format(pattern, args);
            }
        }, locale);
    }

    public static String format(String pattern, Object ... args) {
        return Humanize.messageFormat(pattern).render(args);
    }

    public static String formatCurrency(Number value) {
        DecimalFormat decf = context.get().getCurrencyFormat();
        return Humanize.stripZeros(decf, decf.format(value));
    }

    public static String formatCurrency(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.formatCurrency(value);
            }
        }, locale);
    }

    public static String formatDate(Date value) {
        return Humanize.formatDate(3, value);
    }

    public static String formatDate(final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDate(value);
            }
        }, locale);
    }

    public static String formatDate(Date value, String pattern) {
        return new SimpleDateFormat(pattern, Humanize.currentLocale()).format(value);
    }

    public static String formatDate(final Date value, final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDate(value, pattern);
            }
        }, locale);
    }

    public static String formatDate(int style, Date value) {
        return context.get().formatDate(style, value);
    }

    public static String formatDate(final int style, final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDate(style, value);
            }
        }, locale);
    }

    public static String formatDateTime(Date value) {
        return context.get().formatDateTime(value);
    }

    public static String formatDateTime(final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDateTime(value);
            }
        }, locale);
    }

    public static String formatDateTime(int dateStyle, int timeStyle, Date value) {
        return context.get().formatDateTime(dateStyle, timeStyle, value);
    }

    public static String formatDateTime(final int dateStyle, final int timeStyle, final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDateTime(dateStyle, timeStyle, value);
            }
        }, locale);
    }

    public static String formatDecimal(Number value) {
        return context.get().formatDecimal(value);
    }

    public static String formatDecimal(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.formatDecimal(value);
            }
        }, locale);
    }

    public static String formatPercent(Number value) {
        return context.get().getPercentFormat().format(value);
    }

    public static String formatPercent(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatPercent(value);
            }
        }, locale);
    }

    public static boolean lossyEquals(Locale locale, final String source, final String target) {
        return Humanize.withinLocale(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Humanize.lossyEquals(source, target);
            }
        }, locale);
    }

    public static boolean lossyEquals(String source, String target) {
        Collator c = Collator.getInstance(Humanize.currentLocale());
        c.setStrength(0);
        return c.equals(source, target);
    }

    public static String mask(String mask, String value) {
        return Humanize.maskFormat(mask).format(value);
    }

    public static MaskFormat maskFormat(String mask) {
        MaskFormat maskFmt = context.get().getMaskFormat();
        maskFmt.setMask(mask);
        return maskFmt;
    }

    public static MessageFormat messageFormat(String pattern) {
        MessageFormat msg = context.get().getMessageFormat();
        msg.applyPattern(pattern);
        return msg;
    }

    public static MessageFormat messageFormat(final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<MessageFormat>(){

            @Override
            public MessageFormat call() throws Exception {
                return Humanize.messageFormat(pattern);
            }
        }, locale);
    }

    public static String metricPrefix(Number value) {
        return Humanize.prefix(value, 1000, Constants.metricPrefixes);
    }

    @Expose
    public static String metricPrefix(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.metricPrefix(value);
            }
        }, locale);
    }

    public static String nanoTime(Number value) {
        return Humanize.prefix(value, 1000, Constants.nanoTimePrefixes);
    }

    @Expose
    public static String nanoTime(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.prefix(value, 1000, Constants.nanoTimePrefixes);
            }
        }, locale);
    }

    public static String naturalDay(Date value) {
        return Humanize.naturalDay(3, value);
    }

    @Expose
    public static String naturalDay(Date value, Locale locale) {
        return Humanize.naturalDay(3, value, locale);
    }

    public static String naturalDay(int style, Date value) {
        Date today = new Date();
        long delta = value.getTime() - today.getTime();
        long days = delta / 82800000L;
        if (days == 0L) {
            return context.get().getMessage("today");
        }
        if (days == 1L) {
            return context.get().getMessage("tomorrow");
        }
        if (days == -1L) {
            return context.get().getMessage("yesterday");
        }
        return Humanize.formatDate(style, value);
    }

    public static String naturalDay(final int style, final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.naturalDay(style, value);
            }
        }, locale);
    }

    public static String naturalTime(Date duration) {
        return context.get().formatRelativeDate(duration);
    }

    public static String naturalTime(Date reference, Date duration) {
        return context.get().formatRelativeDate(reference, duration);
    }

    public static String naturalTime(final Date reference, final Date duration, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.naturalTime(reference, duration);
            }
        }, locale);
    }

    @Expose
    public static String naturalTime(Date duration, Locale locale) {
        return Humanize.naturalTime(new Date(), duration, locale);
    }

    public static String ordinal(Number value) {
        int v = value.intValue();
        int vc = v % 100;
        if (vc > 10 && vc < 14) {
            return String.format("%d%s", v, context.get().ordinalSuffix(0));
        }
        return String.format("%d%s", v, context.get().ordinalSuffix(v % 10));
    }

    @Expose
    public static String ordinal(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.ordinal(value);
            }
        }, locale);
    }

    public static String oxford(Collection<?> items) {
        return Humanize.oxford(items.toArray());
    }

    public static String oxford(Collection<?> items, int limit, String limitStr) {
        return Humanize.oxford(items.toArray(), limit, limitStr);
    }

    @Expose
    public static String oxford(Collection<?> items, Locale locale) {
        return Humanize.oxford(items.toArray(), locale);
    }

    public static String oxford(Object[] items) {
        return Humanize.oxford(items, -1, null);
    }

    public static String oxford(Object[] items, int limit, String limitStr) {
        String append;
        String pattern;
        int limitIndex;
        if (items == null || items.length == 0) {
            return "";
        }
        int itemsNum = items.length;
        if (itemsNum == 1) {
            return items[0].toString();
        }
        ResourceBundle bundle = context.get().getBundle();
        if (itemsNum == 2) {
            return Humanize.format(bundle.getString("oxford.pair"), items[0], items[1]);
        }
        int extra = itemsNum - limit;
        if (limit > 0 && extra > 1) {
            limitIndex = limit;
            pattern = Strings.isNullOrEmpty((String)limitStr) ? bundle.getString("oxford.extra") : limitStr;
            append = Humanize.format(pattern, extra);
        } else {
            limitIndex = itemsNum - 1;
            append = items[limitIndex].toString();
        }
        pattern = bundle.getString("oxford");
        return Humanize.format(pattern, Constants.commaJoiner.join(Arrays.copyOf(items, limitIndex)), append);
    }

    public static String oxford(final Object[] items, final int limit, final String limitStr, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.oxford(items, limit, limitStr);
            }
        }, locale);
    }

    public static String oxford(Object[] items, Locale locale) {
        return Humanize.oxford(items, -1, null, locale);
    }

    public static Pace pace(Number value, long interval) {
        Pace.TimeMillis[] intvls;
        double dval = Math.round(value.doubleValue());
        if (dval == 0.0 || interval == 0L) {
            return Pace.EMPTY;
        }
        Pace args = null;
        double rate = Math.abs(dval / (double)interval);
        for (Pace.TimeMillis p : intvls = Pace.TimeMillis.values()) {
            double relativePace = rate * (double)p.millis();
            if (!(relativePace >= 1.0)) continue;
            args = new Pace(Math.round(relativePace), Pace.Accuracy.APROX, p);
            break;
        }
        if (args == null) {
            args = new Pace(1L, Pace.Accuracy.LESS_THAN, intvls[intvls.length - 1]);
        }
        return args;
    }

    public static String paceFormat(Locale locale, final Number value, final long interval) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.paceFormat(value, interval);
            }
        }, locale);
    }

    public static String paceFormat(Locale locale, final Number value, final long interval, final String one, final String many, final String none) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.paceFormat(value, interval, one, many, none);
            }
        }, locale);
    }

    public static String paceFormat(Number value, long interval) {
        ResourceBundle bundle = context.get().getBundle();
        String none = bundle.getString("pace.none");
        String one = bundle.getString("pace.one");
        String many = bundle.getString("pace.many");
        return Humanize.paceFormat(value, interval, one, many, none);
    }

    public static String paceFormat(Number value, long interval, String one, String many, String none) {
        Pace args = Humanize.pace(value, interval);
        ResourceBundle bundle = context.get().getBundle();
        String accuracy = bundle.getString(args.getAccuracy());
        String timeUnit = bundle.getString(args.getTimeUnit());
        return Humanize.capitalize(Humanize.pluralize(one, many, none, (Number)args.getValue(), accuracy, timeUnit));
    }

    public static byte[] parseBase64(String base64str) {
        return DatatypeConverter.parseBase64Binary((String)base64str);
    }

    public static Date parseISODate(String dateStr) {
        return DatatypeConverter.parseDate((String)dateStr).getTime();
    }

    public static Date parseISODateTime(String dateStr) {
        return DatatypeConverter.parseDateTime((String)dateStr).getTime();
    }

    public static Date parseISOTime(String timeStr) {
        return DatatypeConverter.parseTime((String)timeStr).getTime();
    }

    public static Date parseSmartDate(String dateStr, String ... fmts) {
        return Humanize.parseSmartDateWithSeparator(dateStr, "[\\D-_\\s]+", fmts);
    }

    public static Date parseSmartDateWithSeparator(String dateStr, String separator, String ... fmts) {
        String tmp = dateStr.replaceAll(separator, "/");
        for (String fmt : fmts) {
            try {
                DateFormat df = Humanize.dateFormat(fmt);
                df.setLenient(false);
                return df.parse(tmp);
            }
            catch (ParseException ignored) {
            }
        }
        throw new IllegalArgumentException("Unable to parse date '" + dateStr + "'");
    }

    public static String pluralize(Locale locale, final String one, final String many, final Number n, final Object ... exts) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.pluralize(one, many, n, exts);
            }
        }, locale);
    }

    public static String pluralize(Locale locale, final String one, final String many, final String none, final Number n, final Object ... exts) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.pluralize(one, many, none, n, exts);
            }
        }, locale);
    }

    public static String pluralize(String one, String many, Number n, Object ... exts) {
        Object[] objectArray;
        MessageFormat format = Humanize.pluralizeFormat("{0}", many, one, many);
        if (exts == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = n;
        } else {
            objectArray = ObjectArrays.concat((Object)n, (Object[])exts);
        }
        Object[] params = objectArray;
        return format.render(params);
    }

    public static String pluralize(String one, String many, String none, Number n, Object ... exts) {
        Object[] objectArray;
        MessageFormat format = Humanize.pluralizeFormat("{0}", none, one, many);
        if (exts == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = n;
        } else {
            objectArray = ObjectArrays.concat((Object)n, (Object[])exts);
        }
        Object[] params = objectArray;
        return format.render(params);
    }

    public static MessageFormat pluralizeFormat(String template) {
        String[] tokens = template.split("\\s*\\:{2}\\s*");
        if (tokens.length < 4) {
            if (tokens.length == 2) {
                tokens = new String[]{"{0}", tokens[1], tokens[0], tokens[1]};
            } else if (tokens.length == 3) {
                tokens = new String[]{"{0}", tokens[0], tokens[1], tokens[2]};
            } else {
                throw new IllegalArgumentException(String.format("Template '%s' must declare at least 2 tokens. V.gr. 'one thing::{0} things'", template));
            }
        }
        return Humanize.pluralizeFormat(tokens[0], Arrays.copyOfRange(tokens, 1, tokens.length));
    }

    public static MessageFormat pluralizeFormat(final String template, Locale locale) {
        return Humanize.withinLocale(new Callable<MessageFormat>(){

            @Override
            public MessageFormat call() throws Exception {
                return Humanize.pluralizeFormat(template);
            }
        }, locale);
    }

    public static MessageFormat pluralizeFormat(String pattern, String ... choices) {
        double[] indexes = new double[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            indexes[i] = i;
        }
        ChoiceFormat choiceForm = new ChoiceFormat(indexes, choices);
        MessageFormat format = (MessageFormat)Humanize.messageFormat(pattern).clone();
        format.setFormat(0, choiceForm);
        return format;
    }

    public static PrettyTimeFormat prettyTimeFormat() {
        return context.get().getPrettyTimeFormat();
    }

    public static PrettyTimeFormat prettyTimeFormat(Locale locale) {
        return Humanize.withinLocale(new Callable<PrettyTimeFormat>(){

            @Override
            public PrettyTimeFormat call() throws Exception {
                return ((DefaultContext)context.get()).getPrettyTimeFormat();
            }
        }, locale);
    }

    @Expose
    public static String replaceSupplementary(String value) {
        return InterpolationHelper.replaceSupplementary(value, new Replacer(){

            @Override
            public String replace(String in) {
                StringBuilder uc = new StringBuilder();
                for (char c : in.toCharArray()) {
                    uc.append("\\\\u");
                    uc.append(Integer.toHexString(c).toUpperCase());
                }
                return uc.toString();
            }
        });
    }

    public static Number roundToSignificantFigures(Number num, int precision) {
        return new BigDecimal(num.doubleValue()).round(new MathContext(precision, RoundingMode.HALF_EVEN));
    }

    @Expose
    public static String simplify(String text) {
        String normalized = Normalizer.normalize(text, Normalizer.Form.NFD);
        return normalized.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    @Expose
    public static String slugify(String text) {
        String result = Humanize.simplify(text);
        result = Constants.ONLY_SLUG_CHARS.matcher(result).replaceAll("");
        result = CharMatcher.WHITESPACE.trimFrom((CharSequence)result);
        result = Constants.HYPEN_SPACE.matcher(result).replaceAll("-");
        return result.toLowerCase();
    }

    public static String spellBigNumber(Number value) {
        BigDecimal v = new BigDecimal(value.toString());
        if (Constants.THOUSAND.compareTo(v.abs()) > 0) {
            return value.toString();
        }
        boolean isPlural = Humanize.needPlural(v.unscaledValue().intValue());
        for (BigDecimal bigNum : Constants.bigDecExponents.keySet()) {
            if (bigNum.multiply(Constants.THOUSAND).compareTo(v.abs()) <= 0) continue;
            return context.get().formatMessage(isPlural ? Constants.bigDecExponents.get(bigNum) + ".pl" : Constants.bigDecExponents.get(bigNum), v.divide(bigNum));
        }
        return value.toString();
    }

    @Expose
    public static String spellBigNumber(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.spellBigNumber(value);
            }
        }, locale);
    }

    public static String spellDigit(Number value) {
        int v = value.intValue();
        if (v < 0 || v > 9) {
            return value.toString();
        }
        return context.get().digitStrings(v);
    }

    @Expose
    public static String spellDigit(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.spellDigit(value);
            }
        }, locale);
    }

    public static String times(Number num) {
        java.text.MessageFormat f = new java.text.MessageFormat(context.get().getBundle().getString("times.choice"), Humanize.currentLocale());
        return f.format(new Object[]{Math.abs(num.intValue())});
    }

    @Expose
    public static String times(final Number num, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.times(num);
            }
        }, locale);
    }

    @Expose
    public static String titleize(String text) {
        return Humanize.titleize(text, null);
    }

    public static String titleize(String text, String[] intCaps) {
        String str = text.toLowerCase(Locale.ENGLISH).replaceAll("[\\s_]+", " ").trim();
        return Humanize.titleize(str, " ", intCaps);
    }

    @Expose
    public static String underscore(String text) {
        return text.replaceAll("\\s+", "_");
    }

    public static String unmask(String mask, String value) throws ParseException {
        return Humanize.maskFormat(mask).parse(value);
    }

    public static String wordWrap(String value, int len) {
        if (len < 0 || value.length() <= len) {
            return value;
        }
        BreakIterator bi = BreakIterator.getWordInstance(Humanize.currentLocale());
        bi.setText(value);
        return value.substring(0, bi.following(len));
    }

    private static Locale currentLocale() {
        return context.get().getLocale();
    }

    private static ContextFactory loadContextFactory() {
        ServiceLoader<ContextFactory> ldr = ServiceLoader.load(ContextFactory.class);
        for (ContextFactory factory : ldr) {
            if (!DefaultContextFactory.class.isAssignableFrom(factory.getClass())) continue;
            return factory;
        }
        throw new RuntimeException("No ContextFactory was found");
    }

    private static boolean needPlural(int n) {
        int tmp = 0;
        for (int an = Math.abs(n); an > 0; an /= 10) {
            tmp = an % 10;
            if (tmp <= 1) continue;
            return true;
        }
        return false;
    }

    private static String prefix(Number value, int min, Map<Long, String> prefixes) {
        DecimalFormat df = context.get().getDecimalFormat();
        long v = value.longValue();
        if (v < 0L) {
            return value.toString();
        }
        for (Long num : prefixes.keySet()) {
            if (num > v) continue;
            df.applyPattern(prefixes.get(num));
            return Humanize.stripZeros(df, df.format(v >= (long)min ? (double)((float)v / (float)num.longValue()) : (double)v));
        }
        return Humanize.stripZeros(df, df.format(value.toString()));
    }

    private static String resolveInternalCapsWord(String word, String[] internalCaps) {
        for (String ic : internalCaps) {
            if (!word.matches(String.format("(?i)[\\(\\[-]*%s[\\)\\]-]*", ic))) continue;
            return word.replace(ic.toLowerCase(), ic);
        }
        return Humanize.capitalize(word);
    }

    private static String stripZeros(DecimalFormat decf, String fmtd) {
        char decsep = decf.getDecimalFormatSymbols().getDecimalSeparator();
        return fmtd.replaceAll("\\" + decsep + "00", "");
    }

    private static String titleize(String str, String separator, String[] intCaps) {
        StringBuilder sb = new StringBuilder(str.length());
        String[] parts = str.split(separator);
        for (int i = 0; i < parts.length; ++i) {
            boolean notLastWord;
            String word = parts[i];
            boolean bl = notLastWord = i < parts.length - 1;
            if (i > 0 && notLastWord && Constants.titleIgnoredWords.contains(word)) {
                sb.append(word);
            } else {
                Matcher m = Constants.titleWordSperator.matcher(word);
                if (m.find()) {
                    sb.append(Humanize.titleize(word, m.group(1), intCaps));
                    while (m.find()) {
                        sb.append(Humanize.titleize(word, m.group(1), intCaps));
                    }
                } else {
                    sb.append(intCaps == null ? Humanize.capitalize(word) : Humanize.resolveInternalCapsWord(word, intCaps));
                }
            }
            if (!notLastWord) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    private static <T> T withinLocale(Callable<T> operation, Locale locale) {
        DefaultContext ctx = context.get();
        Locale oldLocale = ctx.getLocale();
        try {
            ctx.setLocale(locale);
            T t = operation.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ctx.setLocale(oldLocale);
            context.set(ctx);
        }
    }

    private Humanize() {
    }
}

