/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.support;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.histone.v2.parser.node.AstNode;
import ru.histone.v2.parser.node.ExpAstNode;
import ru.histone.v2.parser.node.StringAstNode;
import ru.histone.v2.utils.PathUtils;

public class TestProcessorClassRegistry {
    private Map<Path, String> pathsMap = new ConcurrentHashMap<Path, String>();
    private Path basePath;

    public TestProcessorClassRegistry(Path basePath) {
        this.basePath = basePath;
    }

    public void processAst(Path tplPath, AstNode node) {
        if (node.hasValue()) {
            return;
        }
        if (this.checkCallIsRequire((ExpAstNode)node)) {
            this.processRequireNode(tplPath, (ExpAstNode)node);
        } else {
            for (AstNode n : ((ExpAstNode)node).getNodes()) {
                this.processAst(tplPath, n);
            }
        }
    }

    private void processRequireNode(Path tplPath, ExpAstNode node) {
        String requirePath = (String)((StringAstNode)node.getNode(2)).getValue();
        Path p = Paths.get(PathUtils.resolveUrl((String)requirePath, (String)tplPath.toString()), new String[0]);
        Path relativeClassPath = this.basePath.relativize(p);
        String name = "Template" + relativeClassPath.getFileName().toString().replace(".", "");
        String className = "class:" + relativeClassPath.getParent().toString().replace("/", ".") + "." + name;
        this.pathsMap.putIfAbsent(relativeClassPath, className);
        node.getNodes().set(2, new StringAstNode(className));
    }

    private boolean checkCallIsRequire(ExpAstNode node) {
        if (node.size() < 3) {
            return false;
        }
        AstNode fNameNode = node.getNode(1);
        return fNameNode.hasValue() && fNameNode instanceof StringAstNode && ((StringAstNode)fNameNode).getValue() != null && ((String)((StringAstNode)fNameNode).getValue()).equals("require");
    }

    public String getClassName(Path path) {
        return null;
    }
}

