/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.support;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ru.histone.v2.acceptance.HistoneTestCase;
import ru.histone.v2.exceptions.ParserException;
import ru.histone.v2.java_compiler.bcompiler.Translator;
import ru.histone.v2.java_compiler.support.TestProcessorClassRegistry;
import ru.histone.v2.parser.Parser;
import ru.histone.v2.parser.SsaOptimizer;
import ru.histone.v2.parser.node.AstNode;
import ru.histone.v2.utils.AstJsonProcessor;
import ru.histone.v2.utils.ParserUtils;

public class TestProcessor {
    private static final String TEST_GENERATED_CLASSES_LOCATION = "/generated-test-sources";
    private static final String TEST_CLASSES_LOCATION = "/test-classes";
    private static final String TEST_JSON_LOCATION = "/test-classes/ru/histone/v2/acceptance";

    public void doCompile(String baseDir) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<List<HistoneTestCase>> type = new TypeReference<List<HistoneTestCase>>(){};
        Translator translator = new Translator();
        Parser parser = new Parser();
        Path jsonBaseDirPath = Paths.get(URI.create("file://" + baseDir + TEST_JSON_LOCATION));
        Path classesDirPath = Paths.get(URI.create("file://" + baseDir + TEST_GENERATED_CLASSES_LOCATION));
        Path testClassesDirPath = Paths.get(URI.create("file://" + baseDir + TEST_CLASSES_LOCATION));
        this.print("Start processing json-tests from '%s'", jsonBaseDirPath);
        Files.walk(jsonBaseDirPath, new FileVisitOption[0]).forEach(arg_0 -> this.lambda$doCompile$0(mapper, (TypeReference)type, translator, parser, jsonBaseDirPath, classesDirPath, testClassesDirPath, arg_0));
    }

    private AstNode processTestFile(ObjectMapper mapper, TypeReference type, Translator translator, Parser parser, Path jsonBaseDirPath, Path classesDirPath, Path testClassesPath, Path jsonFilePath, AstNode root) throws IOException {
        this.print("Processing file '%s'...", this.getPathFromBaseDir(jsonBaseDirPath, jsonFilePath));
        Stream<String> stringStream = Files.lines(jsonFilePath);
        TestProcessorClassRegistry registry = new TestProcessorClassRegistry(testClassesPath);
        List histoneCases = (List)mapper.readValue(stringStream.collect(Collectors.joining()), type);
        for (HistoneTestCase cases : histoneCases) {
            this.print("  Start processTemplate test '%s'", cases.getName());
            ArrayList<HistoneTestCase.Case> casesToRemove = new ArrayList<HistoneTestCase.Case>();
            int i = 0;
            for (HistoneTestCase.Case testCase : cases.getCases()) {
                try {
                    if (StringUtils.isNotBlank((CharSequence)testCase.getInput())) {
                        System.out.println("    Compiling template " + testCase.getInput());
                        root = parser.process(testCase.getInput(), jsonFilePath.toString());
                    } else if (StringUtils.isNotBlank((CharSequence)testCase.getInputAST())) {
                        System.out.println("    Compiling template " + testCase.getInputAST());
                        root = AstJsonProcessor.read((String)testCase.getInputAST());
                    } else {
                        System.out.println("    Compiling template from file " + testCase.getInputFile());
                        String fileName = StringUtils.substring((String)jsonFilePath.getFileName().toString(), (int)0, (int)-5);
                        String tplFilePath = jsonFilePath.getParent().toString() + "/tpl/" + fileName + "/" + testCase.getInputFile();
                        Stream<String> tplFile = Files.lines(Paths.get(tplFilePath, new String[0]));
                        root = parser.process(tplFile.collect(Collectors.joining()), jsonFilePath.toString());
                    }
                    registry.processAst(jsonFilePath, root);
                    String packageName = this.createPackage(jsonBaseDirPath, jsonFilePath.getParent());
                    String className = this.compileTemplates(translator, packageName, classesDirPath, root, cases.getName(), i);
                    testCase.setInputClass(className);
                }
                catch (ParserException ignore) {
                    casesToRemove.add(testCase);
                }
                ++i;
            }
            cases.getCases().removeAll(casesToRemove);
        }
        String resFile = mapper.writeValueAsString((Object)histoneCases);
        Files.write(jsonFilePath, resFile.getBytes(), new OpenOption[0]);
        return root;
    }

    private String getPathFromBaseDir(Path basePath, Path path) {
        String pathStr = path.toString();
        String basePathStr = basePath.toString();
        return pathStr.substring(basePathStr.length(), pathStr.length());
    }

    private String createPackage(Path basePath, Path path) {
        String res = this.getPathFromBaseDir(basePath, path);
        res = "ru/histone/v2/acceptance" + res;
        res = res.replaceAll("/", ".");
        return res;
    }

    private String compileTemplates(Translator translator, String packageName, Path path, AstNode root, String testName, int caseNumber) throws IOException {
        String number = caseNumber == -1 ? "" : caseNumber + "";
        String name = "Template" + testName.replaceAll("[\\s*\\-\\.\\(\\)\\:\\,\\'\\+\\&\\>\\{\\}\\#\\[\\]]", "") + number;
        JavaFile javaFile = translator.createFile(packageName, name, root);
        javaFile.writeTo(path);
        return packageName + "." + name;
    }

    private void print(String message, Object ... args) {
        System.out.println(String.format(message, args));
    }

    private /* synthetic */ void lambda$doCompile$0(ObjectMapper mapper, TypeReference type, Translator translator, Parser parser, Path jsonBaseDirPath, Path classesDirPath, Path testClassesDirPath, Path jsonFilePath) {
        block11: {
            if (jsonFilePath.toString().endsWith("optimize.json")) {
                return;
            }
            AstNode root = null;
            try {
                if (Files.isDirectory(jsonFilePath, new LinkOption[0])) break block11;
                if (jsonFilePath.toString().endsWith(".json")) {
                    root = this.processTestFile(mapper, type, translator, parser, jsonBaseDirPath, classesDirPath, testClassesDirPath, jsonFilePath, root);
                    break block11;
                }
                if (!jsonFilePath.toString().endsWith("tpl")) break block11;
                this.print("Compiling template '%s'...", this.getPathFromBaseDir(jsonBaseDirPath, jsonFilePath));
                String str = Files.lines(jsonFilePath).collect(Collectors.joining("\n"));
                if (ParserUtils.isAst((String)str)) {
                    root = AstJsonProcessor.read((String)str);
                    SsaOptimizer optimizer = new SsaOptimizer();
                    optimizer.process(root);
                } else {
                    try {
                        root = parser.process(str, jsonFilePath.toString());
                    }
                    catch (ParserException optimizer) {
                        // empty catch block
                    }
                }
                if (root != null) {
                    String packageName = this.createPackage(jsonBaseDirPath, jsonFilePath.getParent());
                    String className = this.compileTemplates(translator, packageName, classesDirPath, root, jsonFilePath.getFileName().toString(), -1);
                    String classDef = "class:" + className;
                    Files.write(jsonFilePath, classDef.getBytes(), new OpenOption[0]);
                } else {
                    Files.write(jsonFilePath, "".getBytes(), new OpenOption[0]);
                }
            }
            catch (Exception e) {
                if (root != null) {
                    System.out.println("    Compiled template " + AstJsonProcessor.write(root));
                }
                throw new RuntimeException(e);
            }
        }
    }
}

