/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class TemplateFileObject
extends SimpleJavaFileObject {
    public static final String JAVA_EXTENSION = ".java";
    private final CharSequence source;
    private ByteArrayOutputStream byteCode;

    public TemplateFileObject(String className, CharSequence source) {
        super(URI.create(className + JAVA_EXTENSION), JavaFileObject.Kind.SOURCE);
        this.source = source;
    }

    public TemplateFileObject(String className, JavaFileObject.Kind kind) {
        super(URI.create(className + JAVA_EXTENSION), kind);
        this.source = null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.source == null) {
            throw new UnsupportedOperationException("getCharContent()");
        }
        return this.source;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public OutputStream openOutputStream() {
        this.byteCode = new ByteArrayOutputStream();
        return this.byteCode;
    }

    public byte[] getByteCode() {
        return this.byteCode.toByteArray();
    }
}

