/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.support;

import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.histone.v2.exceptions.ParserException;
import ru.histone.v2.java_compiler.bcompiler.Translator;
import ru.histone.v2.java_compiler.java_evaluator.HistoneClassRegistry;
import ru.histone.v2.java_compiler.java_evaluator.support.HistoneFileManager;
import ru.histone.v2.java_compiler.java_evaluator.support.HistoneTemplateCompilerException;
import ru.histone.v2.java_compiler.java_evaluator.support.TemplateFileObject;
import ru.histone.v2.java_compiler.support.TemplateFileUtils;
import ru.histone.v2.parser.Parser;
import ru.histone.v2.parser.node.AstNode;
import ru.histone.v2.parser.node.ExpAstNode;
import ru.histone.v2.utils.AstJsonProcessor;
import ru.histone.v2.utils.ParserUtils;

public class HistoneTemplateCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(HistoneTemplateCompiler.class);
    private final HistoneClassRegistry registry;
    private final HistoneFileManager fileManager;
    private final JavaCompiler compiler;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final Parser parser;
    private final Translator histoneTranslator;

    public HistoneTemplateCompiler(HistoneClassRegistry registry, Parser parser, Translator histoneTranslator) {
        this.registry = registry;
        this.parser = parser;
        this.histoneTranslator = histoneTranslator;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.diagnostics = new DiagnosticCollector();
        StandardJavaFileManager javaFileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        this.fileManager = new HistoneFileManager(javaFileManager, registry);
    }

    public void compile(Map<String, String> classes) {
        if (classes.isEmpty()) {
            return;
        }
        ArrayList<TemplateFileObject> sources = new ArrayList<TemplateFileObject>();
        for (Map.Entry<String, String> entry : classes.entrySet()) {
            String qualifiedClassName = entry.getKey();
            CharSequence javaSource = entry.getValue();
            if (javaSource == null) continue;
            int dotPos = qualifiedClassName.lastIndexOf(46);
            String className = dotPos == -1 ? qualifiedClassName : qualifiedClassName.substring(dotPos + 1);
            String packageName = dotPos == -1 ? "" : qualifiedClassName.substring(0, dotPos);
            TemplateFileObject source = new TemplateFileObject(className, javaSource);
            sources.add(source);
            this.fileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + ".java", source);
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        options.add(this.getClassPathForCompile());
        this.diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, this.diagnostics, options, null, sources);
        Boolean result = task.call();
        if (BooleanUtils.isFalse((Boolean)result)) {
            StringBuilder cause = new StringBuilder("\n");
            for (Diagnostic<JavaFileObject> d : this.diagnostics.getDiagnostics()) {
                cause.append(d).append(" ");
            }
            throw new HistoneTemplateCompilerException("Compilation failed. Causes: " + cause);
        }
    }

    protected String getClassPathForCompile() {
        URL[] urls = ((URLClassLoader)this.registry.getClass().getClassLoader()).getURLs();
        String classPath = "";
        for (URL classUrl : urls) {
            classPath = classPath + ":" + classUrl.toString();
        }
        return classPath;
    }

    public String translate(String baseURI, String inputStr) throws IOException {
        JavaFile file;
        ExpAstNode root;
        if (ParserUtils.isAst((String)inputStr)) {
            root = AstJsonProcessor.read((String)inputStr);
        } else {
            try {
                root = this.parser.process(inputStr, baseURI);
            }
            catch (ParserException e) {
                LOG.error(e.getMessage() + " in line " + e.getLine() + " in file '" + baseURI + "'", (Throwable)e);
                return null;
            }
        }
        String fileName = TemplateFileUtils.getSimpleClassName(baseURI);
        try {
            file = this.histoneTranslator.createFile(TemplateFileUtils.getPackageName(baseURI), fileName, (AstNode)root);
        }
        catch (Throwable e) {
            LOG.error("Error on translate template '" + fileName + "'", e);
            return null;
        }
        StringBuilder sb = new StringBuilder();
        file.writeTo((Appendable)sb);
        return sb.toString();
    }
}

