/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.support;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import ru.histone.v2.java_compiler.java_evaluator.HistoneClassRegistry;
import ru.histone.v2.java_compiler.java_evaluator.support.TemplateFileObject;

public class HistoneFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final HistoneClassRegistry registry;
    private Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

    public HistoneFileManager(JavaFileManager fileManager, HistoneClassRegistry registry) {
        super(fileManager);
        this.registry = registry;
    }

    public void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObject file) {
        this.fileObjects.put(this.uri(location, packageName, relativeName), file);
    }

    private URI uri(JavaFileManager.Location location, String packageName, String relativeName) {
        return URI.create(location.getName() + '/' + packageName + '/' + relativeName);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileObject o = this.fileObjects.get(this.uri(location, packageName, relativeName));
        if (o != null) {
            return o;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
        TemplateFileObject file = new TemplateFileObject(qualifiedName, kind);
        this.registry.add(qualifiedName, file);
        return file;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
        if (file instanceof TemplateFileObject) {
            return file.getName();
        }
        return super.inferBinaryName(loc, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
            files.addAll(this.registry.files());
        } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
        }
        for (JavaFileObject file : result) {
            files.add(file);
        }
        return files;
    }

    public void remove(StandardLocation location, String packageName, String relativeName) {
        this.fileObjects.remove(this.uri(location, packageName, relativeName));
    }
}

