/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.loader;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import ru.histone.v2.evaluator.resource.Resource;
import ru.histone.v2.evaluator.resource.loader.Loader;
import ru.histone.v2.exceptions.FunctionExecutionException;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.java_compiler.java_evaluator.HistoneClassRegistry;
import ru.histone.v2.java_compiler.java_evaluator.HistoneTemplateResource;
import ru.histone.v2.java_compiler.support.TemplateFileUtils;

public class JavaHistoneTemplateLoader
implements Loader {
    public static final String CLASS_SCHEME = "class";
    protected HistoneClassRegistry classRegistry;

    public JavaHistoneTemplateLoader(HistoneClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    public CompletableFuture<Resource> loadResource(URI url, Map<String, Object> params) {
        String className = url.toString().replace("class:", "");
        String classFileName = TemplateFileUtils.getSimpleClassName(className);
        String templatePath = this.classRegistry.getOriginBasePath() + classFileName;
        return this.loadClass(className, templatePath);
    }

    protected CompletableFuture<Resource> loadClass(String className, String templatePath) {
        Template t = this.classRegistry.loadInstance(className);
        if (t == null) {
            throw new FunctionExecutionException("Failed to load template '" + className + "'");
        }
        HistoneTemplateResource resource = new HistoneTemplateResource(t, templatePath);
        return CompletableFuture.completedFuture(resource);
    }

    public String getScheme() {
        return CLASS_SCHEME;
    }
}

