/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.loader;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import ru.histone.v2.evaluator.resource.Resource;
import ru.histone.v2.evaluator.resource.loader.Loader;
import ru.histone.v2.exceptions.FunctionExecutionException;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.java_compiler.java_evaluator.HistoneClassRegistry;
import ru.histone.v2.java_compiler.java_evaluator.HistoneTemplateResource;

public class JavaHistoneRawTemplateLoader
implements Loader {
    public static final String RAW_TPL_SCHEME = "rawTpl";
    public static final String PARAM_KEY = "rawTpl";
    protected HistoneClassRegistry classRegistry;

    public JavaHistoneRawTemplateLoader(HistoneClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    public CompletableFuture<Resource> loadResource(URI uri, Map<String, Object> params) {
        String className = uri.toString().replace("rawTpl:", "");
        String templatePath = "";
        String tpl = (String)params.get("rawTpl");
        Template t = this.classRegistry.loadInstanceFromTpl(className, tpl);
        if (t == null) {
            throw new FunctionExecutionException("Failed to load template '" + className + "'");
        }
        HistoneTemplateResource resource = new HistoneTemplateResource(t, templatePath);
        return CompletableFuture.completedFuture(resource);
    }

    public String getScheme() {
        return "rawTpl";
    }
}

