/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.function;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import ru.histone.v2.evaluator.Context;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.evaluator.Evaluator;
import ru.histone.v2.evaluator.function.global.Require;
import ru.histone.v2.evaluator.node.EvalNode;
import ru.histone.v2.evaluator.resource.HistoneResourceLoader;
import ru.histone.v2.exceptions.ResourceLoadException;
import ru.histone.v2.exceptions.StopExecutionException;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.parser.Parser;
import ru.histone.v2.rtti.HistoneType;
import ru.histone.v2.utils.PathUtils;

public class JavaRequire
extends Require {
    public JavaRequire(Executor executor, HistoneResourceLoader resourceLoader, Evaluator evaluator, Parser parser, Converter converter) {
        super(executor, resourceLoader, evaluator, parser, converter);
    }

    protected CompletableFuture<EvalNode> doExecute(Context context, List<EvalNode> args) {
        JavaRequire.checkMinArgsLength(args, (int)1);
        this.checkMaxArgsLength(args, 2);
        JavaRequire.checkTypes((EvalNode)args.get(0), (int)0, Collections.singletonList(HistoneType.T_STRING), Collections.singletonList(String.class));
        String url = (String)this.getValue(args, 0);
        Object params = this.getValue(args, 1, null);
        URI uri = URI.create(url);
        if (StringUtils.isBlank((CharSequence)uri.getScheme())) {
            String fullUri = PathUtils.resolveUrl((String)url, (String)context.getBaseUri()).replace("file:", "fullPathClass:");
            uri = URI.create(fullUri);
        }
        return ((CompletableFuture)this.resourceLoader.load(uri.toString(), context.getBaseUri(), Collections.emptyMap()).thenCompose(res -> {
            try {
                Template tpl = (Template)res.getContent();
                Context ctx = this.createCtx(context, res.getBaseHref(), params);
                return tpl.render(ctx);
            }
            catch (Exception e) {
                throw new ResourceLoadException("Resource import failed! Resource reading error.", (Throwable)e);
            }
        })).exceptionally(e -> {
            if (e.getCause() instanceof StopExecutionException) {
                throw (StopExecutionException)e.getCause();
            }
            this.logger.error(e.getMessage(), e);
            return this.converter.createEvalNode(null);
        });
    }
}

