/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import ru.histone.v2.evaluator.Context;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.evaluator.Evaluator;
import ru.histone.v2.evaluator.data.HistoneMacro;
import ru.histone.v2.evaluator.function.macro.MacroCall;
import ru.histone.v2.evaluator.node.EvalNode;
import ru.histone.v2.evaluator.node.MacroEvalNode;
import ru.histone.v2.evaluator.resource.HistoneResourceLoader;
import ru.histone.v2.exceptions.FunctionExecutionException;
import ru.histone.v2.java_compiler.bcompiler.data.MacroFunction;
import ru.histone.v2.parser.Parser;
import ru.histone.v2.parser.node.AstNode;
import ru.histone.v2.parser.node.ExpAstNode;
import ru.histone.v2.rtti.HistoneType;

public class JavaMacroCall
extends MacroCall
implements Serializable {
    public JavaMacroCall(Executor executor, HistoneResourceLoader resourceLoader, Evaluator evaluator, Parser parser, Converter converter) {
        super(executor, resourceLoader, evaluator, parser, converter);
    }

    public String getName() {
        return "call";
    }

    public CompletableFuture<EvalNode> execute(Context context, List<EvalNode> args) throws FunctionExecutionException {
        MacroEvalNode node = (MacroEvalNode)args.get(0);
        HistoneMacro histoneMacro = (HistoneMacro)node.getValue();
        ArrayList macroArgs = new ArrayList();
        if (histoneMacro.getResult() != null && histoneMacro.getWrappingType() == HistoneMacro.WrappingType.NONE) {
            return CompletableFuture.completedFuture(histoneMacro.getResult());
        }
        List namesOfVars = histoneMacro.getArgs();
        Map defaultsVars = histoneMacro.getDefaultValues();
        List bindArgs = histoneMacro.getBindArgs();
        List paramsInput = this.getParams(args);
        ArrayList params = new ArrayList(bindArgs.size() + paramsInput.size());
        params.addAll(bindArgs);
        params.addAll(paramsInput);
        if (histoneMacro.getWrappingType() == HistoneMacro.WrappingType.GLOBAL) {
            return this.callWrappedGlobalFunction(context, paramsInput, (AstNode)histoneMacro.getBody());
        }
        if (histoneMacro.getWrappingType() == HistoneMacro.WrappingType.VALUE) {
            return this.callWrappedValueFunction(context, paramsInput, (ExpAstNode)histoneMacro.getBody(), histoneMacro.getResult());
        }
        macroArgs.add(this.createSelfObject((EvalNode)node, context.getBaseUri(), params));
        for (int i = 0; i < histoneMacro.getArgs().size(); ++i) {
            String argName = (String)namesOfVars.get(i);
            CompletableFuture<Object> param = i < params.size() && ((EvalNode)params.get(i)).getType() != HistoneType.T_UNDEFINED ? CompletableFuture.completedFuture(params.get(i)) : (defaultsVars.containsKey(argName) ? (CompletableFuture)defaultsVars.get(argName) : this.converter.getValue(null));
            macroArgs.add(param);
        }
        return (CompletableFuture)((MacroFunction)histoneMacro.getBody()).apply(macroArgs);
    }
}

