/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.function;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.histone.v2.evaluator.Context;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.evaluator.Evaluator;
import ru.histone.v2.evaluator.function.global.LoadText;
import ru.histone.v2.evaluator.node.EvalNode;
import ru.histone.v2.evaluator.resource.HistoneResourceLoader;
import ru.histone.v2.evaluator.resource.Resource;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.parser.Parser;
import ru.histone.v2.utils.IOUtils;

public class JavaLoadText
extends LoadText {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLoadText.class);

    public JavaLoadText(Executor executor, HistoneResourceLoader loader, Evaluator evaluator, Parser parser, Converter converter, Map<String, CompletableFuture<EvalNode>> cache) {
        super(executor, loader, evaluator, parser, converter, cache);
    }

    protected CompletableFuture<EvalNode> loadResource(Context context, String path, Map<String, Object> params) {
        return ((CompletableFuture)this.resourceLoader.load(path, context.getBaseUri(), params).exceptionally(ex -> {
            this.logger.error("Error", ex);
            return null;
        })).thenApply(resource -> {
            if (resource == null) {
                return this.converter.createEvalNode(null);
            }
            if (resource.getContentType().equals("template")) {
                return this.loadAST((Resource)resource);
            }
            String content = IOUtils.readStringFromResource((Resource)resource, (String)path);
            return this.converter.createEvalNode((Object)content);
        });
    }

    protected EvalNode loadAST(Resource resource) {
        try {
            Template t = (Template)resource.getContent();
            return this.converter.createEvalNode((Object)t.getStringAst());
        }
        catch (IOException e) {
            LOG.error("Failed to getting ast-tree", (Throwable)e);
            return this.converter.createEvalNode(null);
        }
    }
}

