/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator.function;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.codec.digest.DigestUtils;
import ru.histone.v2.evaluator.Context;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.evaluator.Evaluator;
import ru.histone.v2.evaluator.function.global.Eval;
import ru.histone.v2.evaluator.node.EvalNode;
import ru.histone.v2.evaluator.resource.HistoneResourceLoader;
import ru.histone.v2.exceptions.FunctionExecutionException;
import ru.histone.v2.exceptions.ResourceLoadException;
import ru.histone.v2.exceptions.StopExecutionException;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.parser.Parser;
import ru.histone.v2.rtti.HistoneType;

public class JavaEval
extends Eval {
    public JavaEval(Executor executor, HistoneResourceLoader resourceLoader, Evaluator evaluator, Parser parser, Converter converter) {
        super(executor, resourceLoader, evaluator, parser, converter);
    }

    protected CompletableFuture<EvalNode> doExecute(Context context, List<EvalNode> args) throws FunctionExecutionException {
        EvalNode templateNode = args.get(0);
        if (templateNode.getType() != HistoneType.T_STRING) {
            return this.converter.getValue(null);
        }
        String template = (String)templateNode.getValue();
        EvalNode params = args.size() >= 2 ? args.get(1) : this.converter.createEvalNode(null);
        String baseUri = args.size() > 2 && args.get(2).getType() == HistoneType.T_STRING ? (String)args.get(2).getValue() : context.getBaseUri();
        String className = "ru.histone.generated.Tpl$" + DigestUtils.sha512Hex((String)template);
        URI uri = URI.create("rawTpl:" + className);
        Map<String, String> loadParams = Collections.singletonMap("rawTpl", template);
        return ((CompletableFuture)this.resourceLoader.load(uri.toString(), baseUri, loadParams).thenCompose(res -> {
            try {
                Template tpl = (Template)res.getContent();
                Context ctx = this.createCtx(context, baseUri, params);
                return tpl.render(ctx);
            }
            catch (Exception e) {
                throw new ResourceLoadException("Resource import failed! Resource reading error.", (Throwable)e);
            }
        })).exceptionally(e -> {
            if (e.getCause() instanceof StopExecutionException) {
                throw (StopExecutionException)e.getCause();
            }
            this.logger.error(e.getMessage(), e);
            return this.converter.createEvalNode(null);
        });
    }
}

