/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.java_evaluator;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.java_compiler.bcompiler.StdLibrary;
import ru.histone.v2.java_compiler.bcompiler.Translator;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.java_compiler.java_evaluator.HistoneClassRegistry;
import ru.histone.v2.java_compiler.java_evaluator.support.HistoneTemplateCompiler;
import ru.histone.v2.java_compiler.java_evaluator.support.TemplateFileObject;
import ru.histone.v2.parser.Parser;

public class JavaHistoneClassRegistry
implements HistoneClassRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JavaHistoneClassRegistry.class);
    protected final Path basePath;
    protected final StdLibrary stdLibrary;
    protected final Converter converter;
    protected HistoneTemplateCompiler compiler;
    protected final Map<String, RegistryObj> data = new ConcurrentHashMap<String, RegistryObj>();
    protected final URL[] baseURL;

    public JavaHistoneClassRegistry(URL basePath, StdLibrary stdLibrary, Parser parser, Translator histoneTranslator, Converter converter) {
        this.baseURL = new URL[]{basePath};
        this.basePath = Paths.get(URI.create(basePath.toString()));
        this.stdLibrary = stdLibrary;
        this.converter = converter;
        this.compiler = new HistoneTemplateCompiler(this, parser, histoneTranslator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template loadInstance(String className) {
        RegistryObj obj = this.getOrCreateLock(className);
        if (obj.instance != null) {
            return obj.instance;
        }
        obj.lock.writeLock().lock();
        try {
            Template t;
            URLClassLoader tmp = new URLClassLoader(this.baseURL, this.getClass().getClassLoader());
            obj.instance = t = this.loadTemplateByClassName(className, tmp);
            Template template = t;
            return template;
        }
        finally {
            obj.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String className, JavaFileObject javaFile) {
        RegistryObj obj = this.getOrCreateLock(className);
        obj.lock.writeLock().lock();
        try {
            obj.instance = null;
            obj.file = javaFile;
        }
        finally {
            obj.lock.writeLock().unlock();
        }
    }

    @Override
    public Collection<? extends JavaFileObject> files() {
        return Collections.unmodifiableCollection(this.data.values().stream().filter(x -> x.file != null).map(x -> x.file).collect(Collectors.toList()));
    }

    @Override
    public void remove(String className) {
        RegistryObj obj = this.data.get(className);
        this.data.remove(className, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template loadInstanceFromTpl(String className, String tpl) {
        RegistryObj obj = this.getOrCreateLock(className);
        obj.lock.writeLock().lock();
        try {
            String javaCode;
            try {
                javaCode = this.compiler.translate(className, tpl);
            }
            catch (IOException e) {
                LOG.error("Error translate tpl '" + className + "'", (Throwable)e);
                this.data.remove(className, obj);
                Template template = null;
                obj.lock.writeLock().unlock();
                return template;
            }
            Map<String, String> classesObjects = Collections.singletonMap(className, javaCode);
            this.compiler.compile(classesObjects);
            JavaFileObject file = obj.file;
            if (file != null) {
                Template t;
                obj.instance = t = this.loadTemplateFromFile(file, className);
                if (t != null) {
                    Template template = t;
                    return template;
                }
            }
            this.data.remove(className, obj);
            Template template = null;
            return template;
        }
        finally {
            obj.lock.writeLock().unlock();
        }
    }

    protected RegistryObj getOrCreateLock(String className) {
        return this.data.computeIfAbsent(className, k -> new RegistryObj());
    }

    protected Template loadTemplateFromFile(JavaFileObject file, final String className) {
        final TemplateFileObject castedFile = (TemplateFileObject)file;
        URLClassLoader tmp = new URLClassLoader(this.baseURL, this.getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (className.equals(name)) {
                    byte[] bytes = castedFile.getByteCode();
                    return this.defineClass(className, bytes, 0, bytes.length);
                }
                return super.loadClass(name);
            }
        };
        return this.loadTemplateByClassName(className, tmp);
    }

    protected Template loadTemplateByClassName(String className, URLClassLoader tmp) {
        try {
            Template t = (Template)tmp.loadClass(className).newInstance();
            t.setStdLibrary(this.stdLibrary);
            t.setConverter(this.converter);
            return t;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getOriginBasePath() {
        return this.basePath.toString();
    }

    @Override
    public String getRealBasePath() {
        return this.basePath.toString();
    }

    protected static class RegistryObj {
        public volatile ReadWriteLock lock = new ReentrantReadWriteLock();
        public volatile JavaFileObject file;
        public volatile Template instance;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryObj that = (RegistryObj)o;
            return new EqualsBuilder().append((Object)this.lock, (Object)that.lock).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.lock).toHashCode();
        }
    }
}

