/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.bcompiler;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import ru.histone.v2.evaluator.Context;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.java_compiler.bcompiler.StdLibrary;
import ru.histone.v2.java_compiler.bcompiler.TemplateProcessor;
import ru.histone.v2.java_compiler.bcompiler.data.Template;
import ru.histone.v2.parser.node.AstNode;
import ru.histone.v2.utils.AstJsonProcessor;

public class Translator {
    protected static final String GET_STRING_AST_METHOD_NAME = "getStringAst";
    protected static final String RENDER_METHOD_NAME = "render";
    protected static final String AST_TREE_NAME = "AST_TREE";
    protected static final String CONVERTER_NAME = "cnv";
    protected static final String SET_CONVERTER_METHOD_NAME = "setConverter";
    protected static final String STD_LIBRARY_NAME = "std";
    protected static final String SET_STD_LIBRARY_METHOD_NAME = "setStdLibrary";
    protected TemplateProcessor templateProcessor = new TemplateProcessor();

    public byte[] compile(String name, AstNode root) throws IOException {
        JavaFile file = this.createFile(name, root);
        File resDir = new File("./src/test/java/");
        boolean exists = resDir.createNewFile();
        file.writeTo(resDir);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        String filePath = resDir.getAbsolutePath() + "/ru/histone/v2/acceptance/" + name;
        int result = javaCompiler.run(null, null, null, filePath + ".java");
        Path path = Paths.get(filePath + ".class", new String[0]);
        byte[] res = Files.readAllBytes(path);
        return res;
    }

    public JavaFile createFile(String name, AstNode root) throws IOException {
        JavaFile javaFile = JavaFile.builder((String)"ru.histone.v2.acceptance", (TypeSpec)this.createClass(name, root)).build();
        return javaFile;
    }

    public JavaFile createFile(String packageName, String name, AstNode root) throws IOException {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)this.createClass(name, root)).build();
        return javaFile;
    }

    private TypeSpec createClass(String templateName, AstNode root) throws IOException {
        TypeSpec spec = TypeSpec.classBuilder((String)templateName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(Template.class).addField(this.createSdtLibraryField()).addField(this.createConverterField()).addMethod(this.createSetStdLibraryMethod()).addMethod(this.createSetConverterMethod()).addField(this.createAstTreeField(root)).addMethod(this.createGetAstTreeMethod()).addMethod(this.createRenderMethod(root)).build();
        return spec;
    }

    protected MethodSpec createRenderMethod(AstNode root) throws IOException {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)RENDER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Context.class, "ctx", new Modifier[0]).returns(CompletableFuture.class);
        this.templateProcessor.processTemplate(builder, root);
        MethodSpec res = builder.build();
        return res;
    }

    private FieldSpec createConverterField() {
        FieldSpec res = FieldSpec.builder(Converter.class, (String)CONVERTER_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        return res;
    }

    private MethodSpec createSetConverterMethod() {
        MethodSpec res = MethodSpec.methodBuilder((String)SET_CONVERTER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Converter.class, CONVERTER_NAME, new Modifier[0]).addStatement("this.$L = $L", new Object[]{CONVERTER_NAME, CONVERTER_NAME}).build();
        return res;
    }

    private FieldSpec createSdtLibraryField() {
        FieldSpec res = FieldSpec.builder(StdLibrary.class, (String)STD_LIBRARY_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        return res;
    }

    private MethodSpec createSetStdLibraryMethod() {
        MethodSpec res = MethodSpec.methodBuilder((String)SET_STD_LIBRARY_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(StdLibrary.class, STD_LIBRARY_NAME, new Modifier[0]).addStatement("this.std = std", new Object[0]).build();
        return res;
    }

    private FieldSpec createAstTreeField(AstNode root) {
        FieldSpec res = FieldSpec.builder(String.class, (String)AST_TREE_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{AstJsonProcessor.write((AstNode)root)}).build();
        return res;
    }

    private MethodSpec createGetAstTreeMethod() {
        MethodSpec res = MethodSpec.methodBuilder((String)GET_STRING_AST_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return AST_TREE", new Object[0]).build();
        return res;
    }
}

