/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.bcompiler;

import com.squareup.javapoet.MethodSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import ru.histone.v2.Constants;
import ru.histone.v2.evaluator.data.HistoneRegex;
import ru.histone.v2.evaluator.node.EvalNode;
import ru.histone.v2.evaluator.node.GlobalEvalNode;
import ru.histone.v2.evaluator.node.MapEvalNode;
import ru.histone.v2.java_compiler.bcompiler.data.MacroFunction;
import ru.histone.v2.parser.node.AstNode;
import ru.histone.v2.parser.node.AstType;
import ru.histone.v2.parser.node.CallExpAstNode;
import ru.histone.v2.parser.node.CallType;
import ru.histone.v2.parser.node.DoubleAstNode;
import ru.histone.v2.parser.node.ExpAstNode;
import ru.histone.v2.parser.node.LongAstNode;
import ru.histone.v2.parser.node.StringAstNode;
import ru.histone.v2.parser.node.ValueNode;
import ru.histone.v2.rtti.HistoneType;

public class TemplateProcessor {
    public void processTemplate(MethodSpec.Builder builder, AstNode root) {
        if (root.getType() != AstType.AST_NODELIST) {
            root = new ExpAstNode(AstType.AST_NODELIST, new AstNode[]{root});
        }
        Params params = new Params(builder, root);
        this.addStatement(params, "CompletableFuture<StringBuilder> csb0 = CompletableFuture.completedFuture(new StringBuilder())", new Object[0]);
        this.processNode(params);
        if (!this.checkReturnNode(((ExpAstNode)root).getNodes())) {
            this.addStatement(params, "return std.asString(ctx, csb0)", new Object[0]);
        }
    }

    private void processNode(Params params) {
        if (params.node == null) {
            return;
        }
        if (params.node.hasValue()) {
            ValueNode valueNode = (ValueNode)params.node;
            Object v = valueNode.getValue();
            if (v == null) {
                params.builder.addCode("cnv.getValue($T.NULL)", new Object[]{ObjectUtils.class});
                return;
            }
            if (v instanceof String) {
                params.builder.addCode("cnv.getValue($S)", new Object[]{v});
                return;
            }
            if (valueNode instanceof DoubleAstNode) {
                if (((Double)v).isInfinite() || ((Double)v).isNaN()) {
                    params.builder.addCode("cnv.getValue($T.NULL)", new Object[]{ObjectUtils.class});
                    return;
                }
            } else if (valueNode instanceof LongAstNode) {
                params.builder.addCode("cnv.getValue(" + v + "L)", new Object[0]);
                return;
            }
            params.builder.addCode("cnv.getValue(" + v + ")", new Object[0]);
            return;
        }
        switch (params.node.getType()) {
            case AST_ARRAY: {
                this.processArrayNode(params);
                break;
            }
            case AST_REGEXP: {
                this.processRegExp(params);
                break;
            }
            case AST_THIS: {
                this.processThisNode(params);
                break;
            }
            case AST_GLOBAL: {
                this.processGlobalNode(params);
                break;
            }
            case AST_NOT: {
                this.processNotNode(params);
                break;
            }
            case AST_AND: {
                this.processLogical(params, true);
                break;
            }
            case AST_OR: {
                this.processLogical(params, false);
                break;
            }
            case AST_TERNARY: {
                this.processTernary(params);
                break;
            }
            case AST_ADD: 
            case AST_SUB: 
            case AST_MUL: 
            case AST_DIV: 
            case AST_MOD: 
            case AST_USUB: {
                this.processArithmetical(params);
                break;
            }
            case AST_LT: 
            case AST_GT: 
            case AST_LE: 
            case AST_GE: 
            case AST_EQ: 
            case AST_NEQ: {
                this.processRelation(params);
                break;
            }
            case AST_REF: {
                this.processReferenceNode(params);
                break;
            }
            case AST_CALL: {
                this.processCall(params);
                break;
            }
            case AST_VAR: {
                this.processVarNode(params);
                break;
            }
            case AST_IF: {
                this.processIfNode(params);
                break;
            }
            case AST_FOR: {
                this.processForNode(params.addCtx().addForCtx().incLoop());
                break;
            }
            case AST_WHILE: {
                this.processWhileNode(params.addCtx().addForCtx().incLoop());
                break;
            }
            case AST_MACRO: {
                this.processMacroNode(params.addMacroCtx().addCtx().incMacro());
                break;
            }
            case AST_RETURN: {
                this.processReturnNode(params);
            }
            case AST_NODES: {
                this.processNodes(params.addMacroCtx().addCtx().incMacro());
                break;
            }
            case AST_NODELIST: {
                this.processNodeList(params, false);
                break;
            }
            case AST_BOR: {
                this.processBorNode(params);
                break;
            }
            case AST_BXOR: {
                this.processBxorNode(params);
                break;
            }
            case AST_BAND: {
                this.processBandNode(params);
                break;
            }
            case AST_SUPPRESS: {
                this.processSuppressNode(params);
                break;
            }
            case AST_CONTINUE: {
                this.processContinueNode(params);
                break;
            }
            case AST_BREAK: {
                this.processBreakNode(params);
                break;
            }
            case AST_NOP: {
                this.processNopeNode(params);
            }
        }
    }

    private void processNopeNode(Params params) {
        this.addCode(params, "cnv.getValue(null)", new Object[0]);
    }

    private void processReturnNode(Params params) {
        this.addCode(params, "return csb%s.thenCompose(r%s -> ", params.macroCtxNum, params.macroCtxNum);
        this.processNode(params.withNode(0));
        this.addCode(params, ")\n.exceptionally(cnv.checkThrowable(null));\n", new Object[0]);
    }

    private void processBorNode(Params params) {
        this.addCode(params, "std.processBorNode(", new Object[0]);
        this.processNode(params.withNode(0));
        this.addCode(params, " ,", new Object[0]);
        this.processNode(params.withNode(1));
        this.addCode(params, ")", new Object[0]);
    }

    private void processBxorNode(Params params) {
        this.addCode(params, "std.processBxorNode(", new Object[0]);
        this.processNode(params.withNode(0));
        this.addCode(params, " ,", new Object[0]);
        this.processNode(params.withNode(1));
        this.addCode(params, ")", new Object[0]);
    }

    private void processBandNode(Params params) {
        this.addCode(params, "std.processBandNode(", new Object[0]);
        this.processNode(params.withNode(0));
        this.addCode(params, " ,", new Object[0]);
        this.processNode(params.withNode(1));
        this.addCode(params, ")", new Object[0]);
    }

    private void processLogical(Params params, boolean negateCheck) {
        this.addCode(params, "std.processLogicalNode(", new Object[0]);
        this.processNode(params.withNode(0));
        this.addCode(params, " ,", new Object[0]);
        this.processNode(params.withNode(1));
        this.addCode(params, ", %s)", negateCheck);
    }

    private void processThisNode(Params params) {
        this.addCode(params, "ctx.getValue($T.THIS_CONTEXT_VALUE)", Constants.class, new Object[0]);
    }

    private void processRegExp(Params params) {
        ExpAstNode n = (ExpAstNode)params.node;
        StringAstNode flagsNumNode = (StringAstNode)n.getNode(1);
        boolean isIgnoreCase = false;
        boolean isMultiline = false;
        boolean isGlobal = false;
        int flags = 0;
        if (flagsNumNode != null) {
            String flagStr = (String)flagsNumNode.getValue();
            isIgnoreCase = flagStr.contains("i");
            isMultiline = flagStr.contains("m");
            isGlobal = flagStr.contains("g");
        }
        StringAstNode expNode = (StringAstNode)n.getNode(0);
        String exp = (String)expNode.getValue();
        Pattern pattern = Pattern.compile(exp, flags);
        this.addCode(params, "cnv.getValue(", new Object[0]);
        this.addCode(params, "new $T(", HistoneRegex.class, new Object[0]);
        params.builder.addCode("$L, $L, $L, $T.compile($S, $L)))", new Object[]{isGlobal, isIgnoreCase, isMultiline, Pattern.class, exp, flags});
    }

    private void processSuppressNode(Params params) {
        this.processNode(params.withNode(0));
        this.addCode(params, ";\n", new Object[0]);
    }

    private void processTernary(Params params) {
        ExpAstNode node = (ExpAstNode)params.node;
        this.addCode(params, "std.toBoolean(", new Object[0]);
        this.processNode(params.with(node.getNode(0)));
        this.addCode(params, ") \n? ", new Object[0]);
        this.processNode(params.with(node.getNode(1)));
        this.addCode(params, " \n: ", new Object[0]);
        if (node.size() > 2) {
            this.processNode(params.with(node.getNode(2)));
        } else {
            this.addCode(params, "cnv.getValue(null)", new Object[0]);
        }
    }

    private void processBreakNode(Params params) {
        this.addStatement(params, "break", new Object[0]);
    }

    private void processContinueNode(Params params) {
        this.addStatement(params, "index%s++", params.forCtxNumber);
        this.addStatement(params, "continue", new Object[0]);
    }

    private void processNotNode(Params params) {
        this.addCode(params, "std.asBooleanNot(ctx, ", new Object[0]);
        this.processNode(params.withNode(0));
        this.addCode(params, ")", new Object[0]);
    }

    private void processMacroNode(Params params) {
        ExpAstNode node = (ExpAstNode)params.node;
        this.addCode(params, "std.toMacro(args%s -> {\n", params.macroCounter.count);
        this.addCode(params, "CompletableFuture<$T> csb%s = CompletableFuture.completedFuture(new StringBuilder());\n", StringBuilder.class, params.macroCtxNum);
        this.addCode(params, "CompletableFuture<$T> v%s0 = args%s.get(0);\n", EvalNode.class, (long)params.ctxNum - (Long)this.value(node.getNode(0)), params.macroCounter.count);
        long argsSize = 0L;
        if (node.size() > 2) {
            argsSize = (Long)((LongAstNode)node.getNode(2)).getValue();
            HashMap<Long, AstNode> defValue = new HashMap<Long, AstNode>();
            for (int i = 0; i < (node.size() - 3) / 2; ++i) {
                defValue.put((Long)((LongAstNode)node.getNode(i * 2 + 3)).getValue() + 1L, node.getNode(i * 2 + 4));
            }
            for (long i = 1L; i < argsSize + 1L; ++i) {
                this.addCode(params, "CompletableFuture<EvalNode> v%s%s = args%s.get(%s)", (long)params.ctxNum - (Long)this.value(node.getNode(0)), i, params.macroCounter.count, i);
                if (defValue.size() > 0 && defValue.get(i) != null) {
                    this.addCode(params, "\n.thenCompose(v -> v.getType() == $T.T_UNDEFINED \n? ", HistoneType.class, new Object[0]);
                    this.processNode(params.with((AstNode)defValue.get(i)).decCtx());
                    this.addCode(params, " \n: CompletableFuture.completedFuture(v))", new Object[0]);
                }
                this.addCode(params, ";\n", new Object[0]);
            }
        }
        this.processNode(params.withNode(1));
        if (!node.getNode(1).hasValue() && !this.checkReturnNode(((ExpAstNode)node.getNode(1)).getNodes())) {
            this.addStatement(params, "return std.asString(ctx, csb%s)", params.macroCtxNum);
        }
        this.addCode(params, "}, " + argsSize + ")", new Object[0]);
    }

    private void processGlobalNode(Params params) {
        this.addCode(params, "CompletableFuture.completedFuture(new $T())", GlobalEvalNode.class, new Object[0]);
    }

    private void processVarNode(Params params) {
        ValueNode n = (ValueNode)((ExpAstNode)params.node).getNode(1);
        this.addCode(params, "CompletableFuture<$T> v%s%s = ", EvalNode.class, params.ctxNum, this.value((AstNode)n));
        this.processNode(params.withNode(0));
        this.addCode(params, ";\n", new Object[0]);
    }

    private void processReferenceNode(Params params) {
        ExpAstNode n = (ExpAstNode)params.node;
        this.addCode(params, "v%s%s", (long)params.ctxNum - (Long)this.value(n.getNode(0)), this.value(n.getNode(1)));
    }

    private void processWhileNode(Params params) {
        this.addStatement(params, "int i%s = -1", params.ctxNum);
        this.addCode(params, "while (", new Object[0]);
        if (params.node.size() > 1) {
            this.addCode(params, "std.toBoolean(", new Object[0]);
            this.processNode(params.withNode(1));
            this.addCode(params, ")", new Object[0]);
        } else {
            this.addCode(params, "true", new Object[0]);
        }
        this.addCode(params, ") {\n", new Object[0]);
        this.addStatement(params, "$T self%s = std.constructWhileSelfValue(++i%s)", MapEvalNode.class, params.ctxNum, params.ctxNum);
        this.addStatement(params, "CompletableFuture<$T> v%s0 = CompletableFuture.completedFuture(self%s)", EvalNode.class, params.ctxNum, params.ctxNum);
        this.processNode(params.withNode(0));
        this.addCode(params, "}\n", new Object[0]);
    }

    private void processForNode(Params params) {
        this.addCode(params, "$T arrObj%s = (", EvalNode.class, params.loopCounter.count);
        this.processNode(params.withNode(3).decCtx());
        this.addCode(params, ").join();\n", new Object[0]);
        this.beginControlFlow(params, "if (arrObj%s instanceof $T && ((MapEvalNode) arrObj%s).getValue().size() > 0)", MapEvalNode.class, params.loopCounter.count, params.loopCounter.count);
        this.addStatement(params, "$T arr%s = (MapEvalNode) arrObj%s", MapEvalNode.class, params.ctxNum, params.loopCounter.count);
        this.addStatement(params, "$T index%s = 0", Integer.class, params.forCtxNumber);
        this.addStatement(params, "$T size%s = arr%s.getValue().size()", Integer.class, params.ctxNum, params.ctxNum);
        ExpAstNode n = (ExpAstNode)params.node;
        boolean hasKey = ((ValueNode)n.getNode(0)).getValue() != null;
        boolean hasValue = ((ValueNode)n.getNode(1)).getValue() != null;
        this.beginControlFlow(params, "while (index%s < size%s)", params.forCtxNumber, params.ctxNum);
        this.addStatement(params, "MapEvalNode self%s = std.constructForSelfValue(arr%s, index%s, ((MapEvalNode) arrObj%s).getValue().size() -1)", MapEvalNode.class, params.ctxNum, params.ctxNum, params.forCtxNumber, params.loopCounter.count);
        this.addStatement(params, "CompletableFuture<EvalNode> v%s0 = CompletableFuture.completedFuture(self%s)", params.ctxNum, params.ctxNum);
        if (hasKey) {
            this.addStatement(params, "CompletableFuture<EvalNode> v%s%s= CompletableFuture.completedFuture(self%s.getProperty(cnv, \"key\"))", params.ctxNum, this.value(n.getNode(0)), params.ctxNum);
        }
        if (hasValue) {
            this.addStatement(params, "CompletableFuture<EvalNode> v%s%s= CompletableFuture.completedFuture(self%s.getProperty(cnv, \"value\"))", params.ctxNum, this.value(n.getNode(1)), params.ctxNum);
        }
        this.processNode(params.withNode(2));
        if (!(n.hasValue() || this.checkBreakContinueNode(((ExpAstNode)n.getNode(2)).getNodes()) || this.checkReturnNode(((ExpAstNode)n.getNode(2)).getNodes()))) {
            this.addStatement(params, "index%s++", params.forCtxNumber);
        }
        this.endControlFlow(params);
        int startIndex = 4;
        if (n.size() > startIndex) {
            for (int i = 0; i < (n.size() - startIndex) / 2; ++i) {
                this.addCode(params, "} else if (std.toBoolean(", new Object[0]);
                this.processNode(params.withNode(2 * i + startIndex + 1));
                this.addCode(params, ")) {\n", new Object[0]);
                this.processNode(params.withNode(2 * i + startIndex).addCtx());
            }
            if ((n.size() - 4) % 2 == 1) {
                this.addCode(params, "} else {\n", new Object[0]);
                this.processNode(params.withNode(n.size() - 1).addCtx());
            }
        }
        this.addCode(params, "}\n", new Object[0]);
    }

    private <T> T value(AstNode node) {
        return (T)((ValueNode)node).getValue();
    }

    private void addCode(Params params, String str, Class clazz, Object ... args) {
        params.builder.addCode(String.format(str, args), new Object[]{clazz});
    }

    private void addCode(Params params, String str, Object ... args) {
        params.builder.addCode(String.format(str, args), new Object[0]);
    }

    private void addStatement(Params params, String str, Class clazz, Object ... args) {
        params.builder.addStatement(String.format(str, args), new Object[]{clazz});
    }

    private void addStatement(Params params, String str, Object ... args) {
        params.builder.addStatement(String.format(str, args), new Object[0]);
    }

    private void beginControlFlow(Params params, String str, Object ... args) {
        params.builder.beginControlFlow(String.format(str, args), new Object[0]);
    }

    private void beginControlFlow(Params params, String str, Class clazz, Object ... args) {
        params.builder.beginControlFlow(String.format(str, args), new Object[]{clazz});
    }

    private void endControlFlow(Params params) {
        params.builder.endControlFlow();
    }

    private void processIfNode(Params params) {
        ExpAstNode n = (ExpAstNode)params.node;
        for (int i = 0; i < n.size() / 2; ++i) {
            if (i != 0) {
                this.addCode(params, "} else ", new Object[0]);
            }
            this.addCode(params, "if (std.toBoolean(", new Object[0]);
            this.processNode(params.withNode(2 * i + 1));
            this.addCode(params, ")) {\n", new Object[0]);
            if (((ExpAstNode)params.node).getNode(2 * i).hasValue()) {
                ExpAstNode node = new ExpAstNode(AstType.AST_NODELIST, new AstNode[]{((ExpAstNode)params.node).getNode(2 * i)});
                this.processNode(params.with((AstNode)node));
                continue;
            }
            this.processNode(params.withNode(2 * i).addCtx());
        }
        if (n.size() % 2 == 1) {
            this.addCode(params, "} else {\n", new Object[0]);
            if (((ExpAstNode)params.node).getNode(n.size() - 1).hasValue()) {
                ExpAstNode node = new ExpAstNode(AstType.AST_NODELIST, new AstNode[]{((ExpAstNode)params.node).getNode(n.size() - 1)});
                this.processNode(params.with((AstNode)node));
            } else {
                this.processNode(params.withNode(n.size() - 1).addCtx());
            }
        }
        this.addCode(params, "}\n", new Object[0]);
    }

    private void processRelation(Params params) {
        this.addCode(params, "std.%s(ctx, ", this.getRelationMethod((ExpAstNode)params.node));
        this.processNode(params.withNode(0));
        this.addCode(params, ",", new Object[0]);
        this.processNode(params.withNode(1));
        this.addCode(params, ")", new Object[0]);
    }

    private void processArrayNode(Params params) {
        ExpAstNode n = (ExpAstNode)params.node;
        if (CollectionUtils.isEmpty((Collection)n.getNodes())) {
            this.addCode(params, "std.array()", new Object[0]);
            return;
        }
        this.addCode(params, "std.array(", new Object[0]);
        for (int i = 0; i < n.size(); ++i) {
            this.processNode(params.withNode(i));
            if (i == n.size() - 1) continue;
            this.addCode(params, ",", new Object[0]);
        }
        this.addCode(params, ")", new Object[0]);
    }

    private void processCall(Params params) {
        CallExpAstNode callNode = (CallExpAstNode)params.node;
        if (callNode.getCallType() == CallType.SIMPLE) {
            this.addCode(params, "std.simpleCall(ctx,", new Object[0]);
            if (callNode.size() == 2) {
                if (callNode.getNode(0).getType() == AstType.AST_GLOBAL) {
                    this.addCode(params, "\"" + ((ValueNode)callNode.getNode(1)).getValue() + "\", $T.singletonList(", Collections.class, new Object[0]);
                    this.addCode(params, "CompletableFuture.completedFuture(new $T()))", GlobalEvalNode.class, new Object[0]);
                } else {
                    this.addCode(params, "\"" + ((ValueNode)callNode.getNode(1)).getValue() + "\", $T.singletonList(\n", Collections.class, new Object[0]);
                    this.processNode(params.withNode(0));
                    this.addCode(params, "\n)", new Object[0]);
                }
            } else {
                this.addCode(params, "\"" + ((ValueNode)callNode.getNode(1)).getValue() + "\", $T.asList(\n", Arrays.class, new Object[0]);
                this.processNode(params.withNode(0));
                this.addCode(params, ",\n", new Object[0]);
                for (int i = 2; i < callNode.size(); ++i) {
                    this.processNode(params.withNode(i));
                    if (i == callNode.size() - 1) continue;
                    this.addCode(params, ",", new Object[0]);
                }
                this.addCode(params, "\n)", new Object[0]);
            }
            this.addCode(params, ")", new Object[0]);
        } else if (callNode.getCallType() == CallType.RTTI_M_GET) {
            if (callNode.getNode(0).getType() == AstType.AST_THIS) {
                this.addCode(params, "std.getFromCtx(ctx, ", new Object[0]);
                this.processNode(params.withNode(1));
            } else {
                this.addCode(params, "std.mGet(ctx, ", new Object[0]);
                for (int i = 0; i < callNode.size(); ++i) {
                    this.processNode(params.withNode(i));
                    if (i == callNode.size() - 1) continue;
                    this.addCode(params, ",", new Object[0]);
                }
            }
            this.addCode(params, ")", new Object[0]);
        } else if (!(callNode.getNode(0) instanceof ValueNode)) {
            this.addCode(params, "std.mCall(ctx, ", new Object[0]);
            for (int i = 0; i < callNode.size(); ++i) {
                this.processNode(params.withNode(i));
                if (i == callNode.size() - 1) continue;
                this.addCode(params, ",", new Object[0]);
            }
            this.addCode(params, ")", new Object[0]);
        } else {
            this.addCode(params, "null", new Object[0]);
        }
    }

    private void processArithmetical(Params params) {
        ExpAstNode n = (ExpAstNode)params.node;
        this.addCode(params, "std.%s(ctx, ", this.getArithmeticalMethod(n));
        this.processNode(params.withNode(0));
        if (CollectionUtils.isNotEmpty((Collection)n.getNodes()) && n.getNodes().size() == 2) {
            this.addCode(params, ",", new Object[0]);
            this.processNode(params.withNode(1));
        }
        this.addCode(params, ")", new Object[0]);
    }

    private String getArithmeticalMethod(ExpAstNode node) {
        AstType type = node.getType();
        switch (type) {
            case AST_ADD: {
                return "add";
            }
            case AST_SUB: {
                return "sub";
            }
            case AST_USUB: {
                return "uSub";
            }
            case AST_MUL: {
                return "mul";
            }
            case AST_DIV: {
                return "div";
            }
        }
        return "mod";
    }

    private String getRelationMethod(ExpAstNode node) {
        AstType type = node.getType();
        switch (type) {
            case AST_LT: {
                return "lt";
            }
            case AST_GT: {
                return "gt";
            }
            case AST_LE: {
                return "le";
            }
            case AST_GE: {
                return "ge";
            }
            case AST_EQ: {
                return "eq";
            }
        }
        return "neq";
    }

    private void processNodes(Params params) {
        ExpAstNode n = (ExpAstNode)params.node;
        this.addCode(params, "(($T) args%s -> {", MacroFunction.class, params.macroCounter.count);
        this.addCode(params, "CompletableFuture<$T> csb%s = CompletableFuture.completedFuture(new StringBuilder());\n", StringBuilder.class, params.macroCtxNum);
        this.processNodeList(params, true);
        this.addCode(params, "}).apply($T.emptyList())", Collections.class, new Object[0]);
    }

    private void processNodeList(Params params, boolean returnIsNeeded) {
        ExpAstNode n = (ExpAstNode)params.node;
        for (AstNode node : n.getNodes()) {
            if (this.checkIsCompleteNode(node)) {
                if (node.getType() == AstType.AST_RETURN) {
                    this.addCode(params, "return csb%s.thenCompose(r%s -> ", params.macroCtxNum, params.macroCtxNum);
                    this.processNode(params.with(node).withNode(0));
                    this.addCode(params, ")\n.exceptionally(cnv.checkThrowable(null));\n", new Object[0]);
                    break;
                }
                this.processNode(params.with(node));
                break;
            }
            if (node.getType() == AstType.AST_CONTINUE || node.getType() == AstType.AST_BREAK) {
                this.processNode(params.with(node));
                break;
            }
            this.processNodeInNodeList(params.with(node));
        }
        if (!this.checkReturnNode(n.getNodes()) && returnIsNeeded) {
            this.addStatement(params, "return std.asString(ctx, csb%s)", params.macroCtxNum);
        }
    }

    private void processNodeInNodeList(Params params) {
        if (this.isPrintNode(params.node)) {
            this.addCode(params, "csb%s = ", params.macroCtxNum);
            this.addCode(params, "std.append(ctx, csb%s, ", params.macroCtxNum);
            this.processNode(params);
            this.addCode(params, ")", new Object[0]);
            this.addCode(params, ";\n", new Object[0]);
        } else {
            this.processNode(params);
        }
    }

    private boolean isPrintNode(AstNode node) {
        List<AstType> types = Arrays.asList(AstType.AST_FOR, AstType.AST_IF, AstType.AST_VAR, AstType.AST_CONTINUE, AstType.AST_BREAK, AstType.AST_SUPPRESS, AstType.AST_WHILE);
        return !types.contains(node.getType());
    }

    private boolean checkIfCompleteAndReturn(ExpAstNode node) {
        if (node.size() % 2 != 1) {
            return false;
        }
        int returnCount = 0;
        for (int i = 0; i < node.size(); ++i) {
            AstNode n;
            if (i % 2 == 1 || (n = node.getNode(i)).hasValue() || !this.checkReturnNode(((ExpAstNode)n).getNodes())) continue;
            ++returnCount;
        }
        return returnCount == node.size() / 2 + 1;
    }

    private boolean checkIsCompleteNode(AstNode node) {
        if (node.getType() == AstType.AST_RETURN) {
            return true;
        }
        return node.getType() == AstType.AST_IF && this.checkIfCompleteAndReturn((ExpAstNode)node);
    }

    private boolean checkReturnNode(List<AstNode> nodes) {
        for (AstNode node : nodes) {
            if (!this.checkIsCompleteNode(node)) continue;
            return true;
        }
        return false;
    }

    private boolean checkBreakContinueNode(List<AstNode> nodes) {
        return nodes.stream().filter(n -> n.getType() == AstType.AST_BREAK || n.getType() == AstType.AST_CONTINUE).findFirst().isPresent();
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }
    }

    private static class Params {
        MethodSpec.Builder builder;
        AstNode node;
        int macroCtxNum = 0;
        int forCtxNumber = 0;
        int ctxNum = 0;
        Counter loopCounter = new Counter();
        Counter macroCounter = new Counter();

        Params(MethodSpec.Builder builder, AstNode node) {
            this.builder = builder;
            this.node = node;
        }

        Params with(AstNode node) {
            Params params = new Params(this.builder, node);
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params withNode(int index) {
            Params params = new Params(this.builder, ((ExpAstNode)this.node).getNode(index));
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params addCtx() {
            Params params = new Params(this.builder, this.node);
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum + 1;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params decCtx() {
            Params params = new Params(this.builder, this.node);
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum - 1;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params addMacroCtx() {
            Params params = new Params(this.builder, this.node);
            params.macroCtxNum = this.macroCtxNum + 1;
            params.ctxNum = this.ctxNum;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params addForCtx() {
            Params params = new Params(this.builder, this.node);
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum;
            params.forCtxNumber = this.forCtxNumber + 1;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params incLoop() {
            Params params = new Params(this.builder, this.node);
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            ++params.loopCounter.count;
            params.macroCounter = this.macroCounter;
            return params;
        }

        Params incMacro() {
            Params params = new Params(this.builder, this.node);
            params.macroCtxNum = this.macroCtxNum;
            params.ctxNum = this.ctxNum;
            params.forCtxNumber = this.forCtxNumber;
            params.loopCounter = this.loopCounter;
            params.macroCounter = this.macroCounter;
            ++params.macroCounter.count;
            return params;
        }
    }
}

