/*
 * Decompiled with CFR 0.152.
 */
package ru.histone.v2.java_compiler.bcompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.DoubleBinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.histone.v2.evaluator.Context;
import ru.histone.v2.evaluator.Converter;
import ru.histone.v2.evaluator.NodesComparator;
import ru.histone.v2.evaluator.data.HistoneMacro;
import ru.histone.v2.evaluator.node.DoubleEvalNode;
import ru.histone.v2.evaluator.node.EvalNode;
import ru.histone.v2.evaluator.node.HasProperties;
import ru.histone.v2.evaluator.node.LongEvalNode;
import ru.histone.v2.evaluator.node.MacroEvalNode;
import ru.histone.v2.evaluator.node.MapEvalNode;
import ru.histone.v2.evaluator.node.StringEvalNode;
import ru.histone.v2.java_compiler.bcompiler.data.MacroFunction;
import ru.histone.v2.parser.node.AstType;
import ru.histone.v2.rtti.HistoneType;
import ru.histone.v2.rtti.RttiMethod;
import ru.histone.v2.utils.AsyncUtils;
import ru.histone.v2.utils.ParserUtils;
import ru.histone.v2.utils.RttiUtils;

public class StdLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(StdLibrary.class);
    private final NodesComparator comparator;
    private final Converter converter;

    public StdLibrary(Converter converter) {
        this.converter = converter;
        this.comparator = new NodesComparator(converter);
    }

    public CompletableFuture<EvalNode> sub(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.doArithmetic(first, second, (x, y) -> x - y);
    }

    public CompletableFuture<EvalNode> mod(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.doArithmetic(first, second, (x, y) -> x % y);
    }

    public CompletableFuture<EvalNode> mul(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.doArithmetic(first, second, (x, y) -> x * y);
    }

    public CompletableFuture<EvalNode> div(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.doArithmetic(first, second, (x, y) -> x / y);
    }

    private CompletableFuture<EvalNode> doArithmetic(CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second, DoubleBinaryOperator sup) {
        return AsyncUtils.sequence((CompletableFuture[])new CompletableFuture[]{first, second}).thenCompose(l -> {
            Double rValue;
            Double lValue;
            EvalNode left = (EvalNode)l.get(0);
            EvalNode right = (EvalNode)l.get(1);
            if ((this.converter.isNumberNode(left) || left.getType() == HistoneType.T_STRING) && (lValue = (Double)this.getValue(left).orElse(null)) != null && (this.converter.isNumberNode(right) || right.getType() == HistoneType.T_STRING) && (rValue = (Double)this.getValue(right).orElse(null)) != null) {
                Double res = sup.applyAsDouble(lValue, rValue);
                Optional longValue = ParserUtils.tryLongNumber((Object)res);
                if (longValue.isPresent()) {
                    return this.converter.getValue(longValue.get());
                }
                return this.converter.getValue((Object)res);
            }
            return this.converter.getValue(null);
        });
    }

    private Optional<Double> getValue(EvalNode node) {
        if (node.getType() == HistoneType.T_STRING) {
            return ParserUtils.tryDouble((Object)((StringEvalNode)node).getValue());
        }
        return Optional.of(Double.valueOf(node.getValue() + ""));
    }

    public boolean toBoolean(CompletableFuture<EvalNode> node) {
        return this.converter.nodeAsBoolean(node.join());
    }

    public CompletableFuture<EvalNode> arr(Object ... args) {
        return null;
    }

    public boolean bool(CompletableFuture<EvalNode> apply) {
        return false;
    }

    public CompletableFuture<StringBuilder> append(Context ctx, CompletableFuture<StringBuilder> csb, CompletableFuture<EvalNode> var) {
        if (var == null) {
            return csb;
        }
        return var.thenCompose(node -> RttiUtils.callToString((Context)ctx, (EvalNode)node).thenCompose(v -> csb.thenApply(sb -> sb.append(v.getValue()))));
    }

    public CompletableFuture<EvalNode> asString(Context ctx, CompletableFuture<StringBuilder> csb) {
        return csb.thenCompose(sb -> RttiUtils.callToString((Context)ctx, (EvalNode)this.converter.createEvalNode((Object)sb.toString())));
    }

    public CompletableFuture<EvalNode> asBooleanNot(Context context, CompletableFuture<EvalNode> node) {
        return node.thenCompose(n -> this.converter.getValue((Object)(!this.converter.nodeAsBoolean(n) ? 1 : 0)));
    }

    public CompletableFuture<EvalNode> add(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return AsyncUtils.sequence((CompletableFuture[])new CompletableFuture[]{first, second}).thenCompose(lr -> {
            EvalNode left = (EvalNode)lr.get(0);
            EvalNode right = (EvalNode)lr.get(1);
            if (left.getType() != HistoneType.T_STRING && right.getType() != HistoneType.T_STRING) {
                boolean isLeftNumberNode = this.converter.isNumberNode(left);
                boolean isRightNumberNode = this.converter.isNumberNode(right);
                if (isLeftNumberNode && isRightNumberNode) {
                    Double res = (Double)this.getValue(left).orElse(null) + (Double)this.getValue(right).orElse(null);
                    return this.converter.getNumberFuture(res);
                }
                if (isLeftNumberNode || isRightNumberNode) {
                    return this.converter.getValue(null);
                }
                if (left.getType() == HistoneType.T_ARRAY && right.getType() == HistoneType.T_ARRAY) {
                    MapEvalNode result = new MapEvalNode(new LinkedHashMap());
                    result.append((MapEvalNode)left);
                    result.append((MapEvalNode)right);
                    return CompletableFuture.completedFuture(result);
                }
            }
            return AsyncUtils.sequence((CompletableFuture[])new CompletableFuture[]{RttiUtils.callToString((Context)ctx, (EvalNode)left), RttiUtils.callToString((Context)ctx, (EvalNode)right)}).thenCompose(futures -> {
                StringEvalNode l = (StringEvalNode)futures.get(0);
                StringEvalNode r = (StringEvalNode)futures.get(1);
                return this.converter.getValue((Object)((String)l.getValue() + (String)r.getValue()));
            });
        });
    }

    public CompletableFuture<EvalNode> uSub(Context ctx, CompletableFuture<EvalNode> v) {
        return v.thenApply(n -> {
            if (n instanceof LongEvalNode) {
                Long value = (Long)((LongEvalNode)n).getValue();
                return new LongEvalNode(Long.valueOf(-value.longValue()));
            }
            if (n instanceof DoubleEvalNode) {
                Double value = (Double)((DoubleEvalNode)n).getValue();
                return new DoubleEvalNode(Double.valueOf(-value.doubleValue()));
            }
            if (n instanceof StringEvalNode) {
                String stringValue = (String)((StringEvalNode)n).getValue();
                Optional longOptional = ParserUtils.tryLongNumber((Object)stringValue);
                if (longOptional.isPresent()) {
                    return new LongEvalNode(Long.valueOf(-((Long)longOptional.get()).longValue()));
                }
                Optional doubleOptional = ParserUtils.tryDouble((Object)stringValue);
                if (doubleOptional.isPresent()) {
                    return new DoubleEvalNode(Double.valueOf(-((Double)doubleOptional.get()).doubleValue()));
                }
            }
            return this.converter.createEvalNode(null);
        });
    }

    public CompletableFuture<EvalNode> array(CompletableFuture<EvalNode> ... nodes) {
        if (nodes.length == 0) {
            return CompletableFuture.completedFuture(new MapEvalNode(new LinkedHashMap(0)));
        }
        return AsyncUtils.sequence((CompletableFuture[])nodes).thenApply(nodeList -> {
            LinkedHashMap<String, EvalNode> map = new LinkedHashMap<String, EvalNode>();
            for (int i = 0; i < nodeList.size() / 2; ++i) {
                EvalNode value = (EvalNode)nodeList.get(i * 2);
                EvalNode key = (EvalNode)nodeList.get(i * 2 + 1);
                map.put(key.getValue() + "", value);
            }
            return new MapEvalNode(map);
        });
    }

    public CompletableFuture<EvalNode> mGet(Context ctx, CompletableFuture<EvalNode> ... nodes) {
        return AsyncUtils.sequence((CompletableFuture[])nodes).thenCompose(nodeList -> ctx.call((EvalNode)nodeList.get(0), RttiMethod.RTTI_M_GET.getId(), nodeList));
    }

    public CompletableFuture<EvalNode> simpleCall(Context ctx, String functionName, List<CompletableFuture<EvalNode>> args) {
        return ((CompletableFuture)AsyncUtils.sequence(args).thenCompose(argList -> {
            if (argList.size() >= 1) {
                return ctx.call((EvalNode)argList.get(0), functionName, argList);
            }
            return ctx.call(functionName, argList);
        })).exceptionally(this.converter.checkThrowable(LOG));
    }

    public CompletableFuture<EvalNode> mCall(Context ctx, CompletableFuture<EvalNode> valueNode, CompletableFuture<EvalNode> ... nodes) {
        CompletableFuture argsFuture = AsyncUtils.sequence((CompletableFuture[])nodes);
        return valueNode.thenCompose(value -> argsFuture.thenCompose(args -> {
            if (value.getType() == HistoneType.T_MACRO) {
                ArrayList<EvalNode> arguments = new ArrayList<EvalNode>();
                arguments.add((EvalNode)value);
                arguments.addAll((Collection<EvalNode>)args);
                return ctx.call(value, RttiMethod.RTTI_M_CALL.getId(), arguments);
            }
            if (value.getType() != HistoneType.T_STRING) {
                return this.converter.getValue(null);
            }
            return ctx.call((String)value.getValue(), args);
        }));
    }

    public CompletableFuture<EvalNode> lt(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.comparator.processRelation(first, second, AstType.AST_LT, ctx);
    }

    public CompletableFuture<EvalNode> eq(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.comparator.processRelation(first, second, AstType.AST_EQ, ctx);
    }

    public CompletableFuture<EvalNode> ge(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.comparator.processRelation(first, second, AstType.AST_GE, ctx);
    }

    public CompletableFuture<EvalNode> gt(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.comparator.processRelation(first, second, AstType.AST_GT, ctx);
    }

    public CompletableFuture<EvalNode> le(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.comparator.processRelation(first, second, AstType.AST_LE, ctx);
    }

    public CompletableFuture<EvalNode> neq(Context ctx, CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.comparator.processRelation(first, second, AstType.AST_NEQ, ctx);
    }

    public MapEvalNode constructForSelfValue(MapEvalNode array, int currentIndex, int lastIndex) {
        ArrayList nodes = new ArrayList(((Map)array.getValue()).entrySet());
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        res.put("key", this.converter.createEvalNode(((Map.Entry)nodes.get(currentIndex)).getKey()));
        res.put("value", ((Map.Entry)nodes.get(currentIndex)).getValue());
        res.put("index", this.converter.createEvalNode((Object)currentIndex));
        res.put("last", this.converter.createEvalNode((Object)lastIndex));
        return (MapEvalNode)this.converter.createEvalNode(res);
    }

    public MapEvalNode constructWhileSelfValue(int currentIndex) {
        LinkedHashMap<String, EvalNode> res = new LinkedHashMap<String, EvalNode>();
        res.put("iteration", this.converter.createEvalNode((Object)currentIndex));
        return (MapEvalNode)this.converter.createEvalNode(res);
    }

    public CompletableFuture<EvalNode> toMacro(MacroFunction macroFunction, long argsSize) {
        ArrayList<String> args = new ArrayList<String>();
        int i = 1;
        while ((long)i <= argsSize) {
            args.add(i + "");
            ++i;
        }
        HistoneMacro f = new HistoneMacro(args, (Object)macroFunction, null, Collections.emptyMap(), HistoneMacro.WrappingType.NONE);
        return CompletableFuture.completedFuture(new MacroEvalNode(f));
    }

    public CompletableFuture<EvalNode> getFromCtx(Context ctx, CompletableFuture<EvalNode> nameNode) {
        return AsyncUtils.sequence((CompletableFuture[])new CompletableFuture[]{ctx.getValue("this"), nameNode}).thenApply(list -> {
            EvalNode fromCtx = (EvalNode)list.get(0);
            if (fromCtx instanceof HasProperties) {
                String name = (String)((EvalNode)list.get(1)).getValue();
                return ((HasProperties)fromCtx).getProperty(this.converter, (Object)name);
            }
            return this.converter.createEvalNode(null);
        });
    }

    public CompletableFuture<EvalNode> processLogicalNode(CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second, boolean negateCheck) {
        return first.thenCompose(f -> {
            if (this.converter.nodeAsBoolean(f) ^ negateCheck) {
                return CompletableFuture.completedFuture(f);
            }
            return second;
        });
    }

    public CompletableFuture<EvalNode> processBorNode(CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.processBitwiseNode(first, second, (a, b) -> a | b);
    }

    public CompletableFuture<EvalNode> processBxorNode(CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.processBitwiseNode(first, second, (a, b) -> a ^ b);
    }

    public CompletableFuture<EvalNode> processBandNode(CompletableFuture<EvalNode> first, CompletableFuture<EvalNode> second) {
        return this.processBitwiseNode(first, second, (a, b) -> a & b);
    }

    private CompletableFuture<EvalNode> processBitwiseNode(CompletableFuture<EvalNode> firstFuture, CompletableFuture<EvalNode> secondFuture, BiFunction<Long, Long, Long> function) {
        return AsyncUtils.sequence((CompletableFuture[])new CompletableFuture[]{firstFuture, secondFuture}).thenApply(f -> {
            long first = 0L;
            if (((EvalNode)f.get(0)).getType() == HistoneType.T_NUMBER) {
                first = (Long)((EvalNode)f.get(0)).getValue();
            } else if (((EvalNode)f.get(0)).getType() == HistoneType.T_BOOLEAN) {
                first = this.converter.nodeAsBoolean((EvalNode)f.get(0)) ? 1L : 0L;
            }
            long second = 0L;
            if (((EvalNode)f.get(1)).getType() == HistoneType.T_NUMBER) {
                second = (Long)((EvalNode)f.get(1)).getValue();
            } else if (((EvalNode)f.get(1)).getType() == HistoneType.T_BOOLEAN) {
                second = this.converter.nodeAsBoolean((EvalNode)f.get(1)) ? 1L : 0L;
            }
            return this.converter.createEvalNode(function.apply(first, second));
        });
    }
}

