/*
 * Decompiled with CFR 0.152.
 */
package com.github.mchernyakov.variousttlmap.applied.cleaner;

import com.github.mchernyakov.variousttlmap.VariousTtlMapImpl;
import com.github.mchernyakov.variousttlmap.applied.cleaner.AbstractBackgroundMapCleaner;
import com.github.mchernyakov.variousttlmap.applied.cleaner.BackgroundMapCleaner;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Phaser;
import java.util.stream.IntStream;

public class MultiThreadMapCleaner<K, V>
extends AbstractBackgroundMapCleaner<K, V> {
    private final BlockingQueue<List<K>> blockingQueue;
    private final Phaser phaser = new Phaser();
    private volatile boolean isInitChunks = false;

    public MultiThreadMapCleaner(VariousTtlMapImpl<K, V> variousTtlMap, BackgroundMapCleaner.Builder<K, V> builder) {
        super(variousTtlMap, builder);
        this.blockingQueue = new ArrayBlockingQueue<List<K>>(this.poolSize);
    }

    @Override
    void additionalInit() {
        this.phaser.register();
    }

    @Override
    void additionalFinally() {
        this.phaser.arriveAndDeregister();
        if (this.phaser.getArrivedParties() == 0) {
            this.isInitChunks = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<K> getKeys() {
        if (!this.isInitChunks) {
            MultiThreadMapCleaner multiThreadMapCleaner = this;
            synchronized (multiThreadMapCleaner) {
                if (!this.isInitChunks) {
                    this.initAndPutChunks();
                    this.isInitChunks = true;
                }
            }
        }
        return (List)this.blockingQueue.poll();
    }

    private void initAndPutChunks() {
        Set keys = this.map.getStore().keySet();
        List chunks = this.buildChunks(keys);
        chunks.forEach(this::offerChunk);
    }

    @VisibleForTesting
    List<List<K>> buildChunks(Set<K> keys) {
        ArrayList chunks = new ArrayList();
        IntStream.range(0, this.poolSize).forEach(i -> chunks.add(new ArrayList()));
        int counter = 0;
        for (K key : keys) {
            int index = counter % this.poolSize;
            ((List)chunks.get(index)).add(key);
            ++counter;
        }
        return chunks;
    }

    private void offerChunk(List<K> chunk) {
        boolean res = this.blockingQueue.offer(chunk);
        if (!res) {
            throw new IllegalStateException("queue capacity lower than chunk count");
        }
    }
}

