/*
 * Decompiled with CFR 0.152.
 */
package com.github.mchernyakov.variousttlmap.applied.cleaner;

import com.github.mchernyakov.variousttlmap.VariousTtlMapImpl;
import com.github.mchernyakov.variousttlmap.applied.cleaner.MultiThreadMapCleaner;
import com.github.mchernyakov.variousttlmap.applied.cleaner.SingleThreadMapCleaner;
import com.github.mchernyakov.variousttlmap.util.Preconditions;
import org.jetbrains.annotations.NotNull;

public interface BackgroundMapCleaner<K, V> {
    public void startCleaners();

    public void shutdown();

    public static final class Builder<K, V> {
        private static final int DEFAULT_POOL_SIZE = 1;
        long delayTime;
        int poolSize = 1;
        int numKeyCheck;
        int percentWaterMark;

        private Builder() {
        }

        public static Builder<Object, Object> newBuilder() {
            return new Builder<Object, Object>();
        }

        public Builder<K, V> setDelayTime(long delayTime) {
            this.delayTime = delayTime;
            return this;
        }

        public Builder<K, V> setPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public Builder<K, V> setNumKeyCheck(int numKeyCheck) {
            this.numKeyCheck = numKeyCheck;
            return this;
        }

        public Builder<K, V> setPercentWaterMark(int percentWaterMark) {
            this.percentWaterMark = percentWaterMark;
            return this;
        }

        public <K1 extends K, V1 extends V> BackgroundMapCleaner<K1, V1> build(@NotNull VariousTtlMapImpl<K1, V1> map) {
            Preconditions.checkNotNull(map);
            Builder self = this;
            if (this.poolSize > 1) {
                return new MultiThreadMapCleaner<K1, V1>(map, self);
            }
            return new SingleThreadMapCleaner<K1, V1>(map, self);
        }
    }
}

