/*
 * Decompiled with CFR 0.152.
 */
package com.github.mchernyakov.variousttlmap.applied;

import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PrimitiveMapWrapper {
    private final Int2LongOpenHashMap primitiveMap;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public PrimitiveMapWrapper() {
        this.primitiveMap = new Int2LongOpenHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int hash, long value) {
        this.writeLock.lock();
        try {
            this.primitiveMap.put(hash, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(int hash) {
        this.writeLock.lock();
        try {
            this.primitiveMap.remove(hash);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int hash) {
        this.readLock.lock();
        try {
            long l = this.primitiveMap.get(hash);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.primitiveMap.clear();
    }
}

