/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.MyExcelConfiguration;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileOperator {
    private static final Logger log = LoggerFactory.getLogger(TempFileOperator.class);
    private static final int MAX_CREATE_NO = 9999;
    private static int createNo;

    public static Path createTempFile(String prefix, String suffix) {
        try {
            return Files.createTempFile(MyExcelConfiguration.temporaryFileDirectory(), TempFileOperator.getTempFileName(prefix), suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw ExcelBuildException.of("Failed to create temp file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTempFileName(String prefix) {
        long currentTimeMillis = System.currentTimeMillis();
        Class<TempFileOperator> clazz = TempFileOperator.class;
        synchronized (TempFileOperator.class) {
            if (createNo > 9999) {
                createNo = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return prefix + "_" + Thread.currentThread().getId() + "_" + currentTimeMillis + "_" + ++createNo;
        }
    }

    public static void deleteTempFiles(List<Path> paths) {
        if (Objects.isNull(paths)) {
            return;
        }
        for (Path path : paths) {
            TempFileOperator.deleteTempFile(path);
        }
    }

    public static void deleteTempFile(Path path) {
        if (Objects.isNull(path)) {
            return;
        }
        try {
            boolean delSuccess;
            if (Files.exists(path, new LinkOption[0]) && !(delSuccess = Files.deleteIfExists(path))) {
                log.warn("Delete temp file failure,fileName:{}", (Object)path.toFile().getName());
            }
        }
        catch (IOException e) {
            log.warn("Delete temp file failure", (Throwable)e);
        }
    }

    public static Path convertToFile(InputStream is) {
        Path tempFile = TempFileOperator.createTempFile("i_t", ".xlsx");
        try (FileOutputStream fos = new FileOutputStream(tempFile.toFile());){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            TempFileOperator.deleteTempFile(tempFile);
            throw new SaxReadException("Fail to convert file inputStream to temp file", e);
        }
        return tempFile;
    }
}

