/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.style.CustomColor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.util.HSSFColor;

public final class ColorUtil {
    private static final String HASH = "#";
    private static final String RGB = "rgb";
    private static final Map<String, HSSFColor.HSSFColorPredefined> COLOR_PREDEFINED_MAP = Arrays.stream(HSSFColor.HSSFColorPredefined.values()).collect(Collectors.toMap(c -> c.toString().toLowerCase().replaceAll("_", ""), c -> c));

    public static Short getPredefinedColorIndex(String color) {
        HSSFColor.HSSFColorPredefined colorPredefined = COLOR_PREDEFINED_MAP.get(color);
        if (Objects.isNull(colorPredefined)) {
            return null;
        }
        return colorPredefined.getIndex();
    }

    public static Short getCustomColorIndex(@NonNull CustomColor customColor, @NonNull String color) {
        if (customColor == null) {
            throw new NullPointerException("customColor is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        int[] rgb = ColorUtil.getRGBByColor(color);
        if (Objects.isNull(rgb)) {
            return null;
        }
        return ColorUtil.getCustomColorIndex(customColor, rgb);
    }

    public static Short getCustomColorIndex(@NonNull CustomColor customColor, @NonNull int[] rgb) {
        if (customColor == null) {
            throw new NullPointerException("customColor is marked non-null but is null");
        }
        if (rgb == null) {
            throw new NullPointerException("rgb is marked non-null but is null");
        }
        HSSFPalette palette = customColor.getPalette();
        short index = (short)customColor.getColorIndex().getAndIncrement();
        palette.setColorAtIndex(index, (byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
        return index;
    }

    public static int[] getRGBByColor(@NonNull String color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        int[] result = null;
        if (color.startsWith(HASH)) {
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(5, 7), 16);
            result = new int[]{r, g, b};
        } else if (color.startsWith(RGB)) {
            String rgbColor = color.replace(RGB, "").replace("(", "").replace(")", "");
            String[] rgbColorArr = rgbColor.split(",");
            List rgb = Arrays.stream(rgbColorArr).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());
            if (rgb.size() != 3) {
                return result;
            }
            int r = (Integer)rgb.get(0);
            int g = (Integer)rgb.get(1);
            int b = (Integer)rgb.get(2);
            result = new int[]{r, g, b};
        }
        return result;
    }
}

