/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ConvertContext;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class BigDecimalWriteConverter
implements WriteConverter {
    @Override
    public boolean support(Field field, Object fieldVal, ConvertContext convertContext) {
        return field.getType() == BigDecimal.class;
    }

    @Override
    public Pair<Class, Object> convert(Field field, Object fieldVal, ConvertContext convertContext) {
        if (!convertContext.isConvertCsv()) {
            return Pair.of(Double.class, ((BigDecimal)fieldVal).toPlainString());
        }
        ExcelColumnMapping excelColumnMapping = convertContext.getExcelColumnMappingMap().get(field);
        String format = convertContext.getConfiguration().getDecimalFormat();
        if (excelColumnMapping != null && !excelColumnMapping.getFormat().isEmpty()) {
            format = excelColumnMapping.getFormat();
        }
        if (format.isEmpty()) {
            return Pair.of(Double.class, ((BigDecimal)fieldVal).toPlainString());
        }
        String[] formatSplits = format.split("\\.");
        BigDecimal value = (BigDecimal)fieldVal;
        if (formatSplits.length == 2) {
            value = value.setScale(formatSplits[1].length(), RoundingMode.HALF_UP);
        }
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return Pair.of(String.class, decimalFormat.format(value));
    }
}

