/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.exception.StopReadException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvReadHandler<T>
extends AbstractReadHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(CsvReadHandler.class);
    private static final Pattern PATTERN_SPLIT = Pattern.compile(",(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
    private static final Pattern PATTERN_QUOTES = Pattern.compile("[\"]{2}");
    private InputStream is;
    private String charset;

    public CsvReadHandler(InputStream is, SaxExcelReader.ReadConfig<T> readConfig, List<T> result) {
        super(true, result, readConfig);
        this.is = is;
        this.charset = readConfig.getCharset();
    }

    public void read() {
        if (this.is == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is, this.charset));){
            String line;
            int lineIndex = 0;
            while ((line = bufferedReader.readLine()) != null) {
                this.newRow(lineIndex);
                if (lineIndex == 0 && line.length() >= 1 && line.charAt(0) == '\ufeff') {
                    line = line.substring(1);
                }
                this.process(line);
                ++lineIndex;
            }
            log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (StopReadException e) {
            log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void process(String line) {
        if (line != null) {
            String[] strArr = PATTERN_SPLIT.split(line, -1);
            int size = strArr.length;
            for (int i = 0; i < size; ++i) {
                String content = strArr[i];
                if (content != null && content.isEmpty()) {
                    content = null;
                }
                if (content != null && content.indexOf("\"") == 0) {
                    content = content.length() > 2 ? content.substring(1, content.length() - 1) : "";
                }
                if (content != null) {
                    content = PATTERN_QUOTES.matcher(content).replaceAll("\"");
                }
                this.handleField(i, content);
            }
        }
        this.handleResult();
    }
}

