/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Configuration;
import com.github.liaochong.myexcel.core.ConvertContext;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.ExcludeColumn;
import com.github.liaochong.myexcel.core.annotation.IgnoreColumn;
import com.github.liaochong.myexcel.core.constant.BooleanDropDownList;
import com.github.liaochong.myexcel.core.constant.DropDownList;
import com.github.liaochong.myexcel.core.constant.File;
import com.github.liaochong.myexcel.core.constant.ImageFile;
import com.github.liaochong.myexcel.core.constant.LinkEmail;
import com.github.liaochong.myexcel.core.constant.LinkUrl;
import com.github.liaochong.myexcel.core.constant.NumberDropDownList;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.StyleParser;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.utils.ConfigurationUtil;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.type.NullType;

abstract class AbstractSimpleExcelBuilder {
    protected List<String> fieldDisplayOrder;
    protected List<Field> filteredFields = Collections.emptyList();
    protected List<String> titles;
    protected Map<Field, String> defaultValueMap = new HashMap<Field, String>();
    protected Map<Integer, Integer> customWidthMap = new HashMap<Integer, Integer>();
    protected int titleLevel = 0;
    private Map<Integer, String> formats = new HashMap<Integer, String>();
    protected boolean isMapBuild;
    private ConvertContext convertContext;
    protected Configuration configuration;
    private Map<Field, ExcelColumnMapping> excelColumnMappingMap;
    protected StyleParser styleParser = new StyleParser(this.customWidthMap);

    public AbstractSimpleExcelBuilder(boolean isCsvBuild) {
        this.convertContext = new ConvertContext(isCsvBuild);
        this.configuration = this.convertContext.getConfiguration();
        this.excelColumnMappingMap = this.convertContext.getExcelColumnMappingMap();
    }

    protected List<Field> getFilteredFields(ClassFieldContainer classFieldContainer, Class<?> ... groups) {
        ConfigurationUtil.parseConfiguration(classFieldContainer, this.configuration);
        this.parseGlobalStyle();
        List<Field> preElectionFields = this.getPreElectionFields(classFieldContainer);
        List<Field> buildFields = this.getGroupFields(preElectionFields, groups);
        ArrayList<String> titles = new ArrayList<String>(buildFields.size());
        int size = buildFields.size();
        for (int i = 0; i < size; ++i) {
            Field field = buildFields.get(i);
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            String[] columnStyles = null;
            if (excelColumn != null) {
                if (this.configuration.isUseFieldNameAsTitle() && excelColumn.title().isEmpty()) {
                    titles.add(field.getName());
                } else {
                    titles.add(excelColumn.title());
                }
                if (!excelColumn.defaultValue().isEmpty()) {
                    this.defaultValueMap.put(field, excelColumn.defaultValue());
                }
                if (excelColumn.width() > -1) {
                    this.customWidthMap.putIfAbsent(i, excelColumn.width());
                }
                if (excelColumn.style().length > 0) {
                    columnStyles = excelColumn.style();
                }
                if (!excelColumn.format().isEmpty()) {
                    this.formats.put(i, excelColumn.format());
                } else if (!excelColumn.decimalFormat().isEmpty()) {
                    this.formats.put(i, excelColumn.decimalFormat());
                } else if (!excelColumn.dateFormatPattern().isEmpty()) {
                    this.formats.put(i, excelColumn.dateFormatPattern());
                }
                ExcelColumnMapping mapping = ExcelColumnMapping.mapping(excelColumn);
                this.excelColumnMappingMap.put(field, mapping);
            } else if (this.configuration.isUseFieldNameAsTitle()) {
                titles.add(field.getName());
            } else {
                titles.add(null);
            }
            this.styleParser.setColumnStyle(field, i, columnStyles);
            this.setGlobalFormat(i, field);
        }
        this.setTitles(titles);
        return buildFields;
    }

    protected void parseGlobalStyle() {
        this.styleParser.parse(this.configuration.getStyle());
    }

    private void setGlobalFormat(int i, Field field) {
        if (this.formats.get(i) != null) {
            return;
        }
        if (field.getType() == LocalDate.class) {
            this.formats.put(i, this.configuration.getDateFormat());
        } else if (ReflectUtil.isDate(field.getType())) {
            this.formats.put(i, this.configuration.getDateTimeFormat());
        } else if (ReflectUtil.isNumber(field.getType()) && this.configuration.getDecimalFormat() != null) {
            this.formats.put(i, this.configuration.getDecimalFormat());
        }
    }

    protected Table createTable() {
        Table table = new Table();
        table.setCaption(this.configuration.getSheetName());
        table.setTrList(new LinkedList<Tr>());
        return table;
    }

    protected List<Tr> createThead() {
        if (this.titles == null || this.titles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tdLists = new ArrayList();
        for (int i = 0; i < this.titles.size(); ++i) {
            String string = this.titles.get(i);
            if (string == null) continue;
            ArrayList<Td> tds = new ArrayList<Td>();
            String[] multiTitles = string.split(this.configuration.getTitleSeparator());
            if (multiTitles.length > this.titleLevel) {
                this.titleLevel = multiTitles.length;
            }
            for (int j = 0; j < multiTitles.length; ++j) {
                Td td2 = new Td(j, i);
                td2.setTh(true);
                td2.setContent(multiTitles[j]);
                tds.add(td2);
            }
            tdLists.add(tds);
        }
        for (List list2 : tdLists) {
            Td last = (Td)list2.get(list2.size() - 1);
            last.setRowSpan(this.titleLevel - last.getRow());
        }
        int i = 0;
        while (i < this.titleLevel) {
            int n = i++;
            Map<String, List<List>> groups = tdLists.stream().filter(list -> list.size() > level).collect(Collectors.groupingBy(list -> ((Td)list.get(level)).getContent()));
            groups.forEach((k, v) -> {
                if (v.size() == 1) {
                    return;
                }
                List tds = v.stream().map(list -> (Td)list.get(level)).sorted(Comparator.comparing(Td::getCol)).collect(Collectors.toList());
                LinkedList subTds = new LinkedList();
                Map<Integer, List<Td>> partitions = tds.stream().collect(Collectors.groupingBy(Td::getRowSpan));
                partitions.forEach((col, subTdList) -> {
                    int splitIndex = 0;
                    int size = subTdList.size() - 1;
                    for (int j = 0; j < size; ++j) {
                        Td current = (Td)subTdList.get(j);
                        Td next = (Td)subTdList.get(j + 1);
                        if (current.getCol() + 1 == next.getCol()) continue;
                        List sub = subTdList.subList(splitIndex, j + 1);
                        splitIndex = j + 1;
                        if (sub.size() <= 1) continue;
                        subTds.add(sub);
                    }
                    subTds.add(subTdList.subList(splitIndex, subTdList.size()));
                });
                subTds.forEach(val -> {
                    if (val.size() == 1) {
                        return;
                    }
                    Td t = (Td)val.get(0);
                    t.setColSpan(val.size());
                    for (int j = 1; j < val.size(); ++j) {
                        ((Td)val.get(j)).setRow(-1);
                    }
                });
            });
        }
        Map<Integer, List<Td>> rowTds = tdLists.stream().flatMap(Collection::stream).filter(td -> td.getRow() > -1).collect(Collectors.groupingBy(Td::getRow));
        ArrayList<Tr> arrayList = new ArrayList<Tr>();
        boolean isComputeAutoWidth = WidthStrategy.isComputeAutoWidth(this.configuration.getWidthStrategy());
        rowTds.forEach((k, v) -> {
            Tr tr = new Tr((int)k, this.configuration.getTitleRowHeight());
            tr.setColWidthMap(isComputeAutoWidth ? new HashMap(this.titles.size()) : Collections.emptyMap());
            List<Td> tds = v.stream().sorted(Comparator.comparing(Td::getCol)).peek(td -> {
                if (isComputeAutoWidth) {
                    tr.getColWidthMap().put(td.getCol(), TdUtil.getStringWidth(td.getContent(), 0.25));
                }
            }).collect(Collectors.toList());
            tr.setTdList(tds);
            trs.add(tr);
        });
        return arrayList;
    }

    protected Tr createTr(List<Pair<? extends Class, ?>> contents) {
        Tr tr = new Tr(0, this.configuration.getRowHeight());
        if (contents.isEmpty()) {
            return tr;
        }
        tr.setColWidthMap(new HashMap<Integer, Integer>());
        List<Td> tdList = IntStream.range(0, contents.size()).mapToObj(index -> {
            Td td = new Td(0, index);
            Pair pair = (Pair)contents.get(index);
            this.setTdContent(td, pair);
            this.setTdContentType(td, (Class)pair.getKey());
            td.setFormat(this.formats.get(index));
            this.setFormula(index, td);
            this.setTdWidth(tr.getColWidthMap(), td);
            return td;
        }).collect(Collectors.toList());
        this.customWidthMap.forEach(tr.getColWidthMap()::put);
        tr.setTdList(tdList);
        return tr;
    }

    private void setTdWidth(Map<Integer, Integer> colWidthMap, Td td) {
        if (!this.configuration.isComputeAutoWidth()) {
            return;
        }
        if (td.getFormat() == null) {
            colWidthMap.put(td.getCol(), TdUtil.getStringWidth(td.getContent()));
        } else if (td.getContent() != null && td.getFormat().length() > td.getContent().length()) {
            colWidthMap.put(td.getCol(), TdUtil.getStringWidth(td.getFormat()));
        } else if (td.getDate() != null || td.getLocalDate() != null || td.getLocalDateTime() != null) {
            colWidthMap.put(td.getCol(), TdUtil.getStringWidth(td.getFormat(), -0.15));
        }
    }

    private void setFormula(int i, Td td) {
        if (this.filteredFields.isEmpty()) {
            return;
        }
        Field field = this.filteredFields.get(i);
        ExcelColumnMapping excelColumnMapping = this.excelColumnMappingMap.get(field);
        if (excelColumnMapping != null && excelColumnMapping.isFormula()) {
            td.setFormula(true);
        }
    }

    private void setTdContent(Td td, Pair<? extends Class, ?> pair) {
        Class fieldType = pair.getKey();
        if (fieldType == NullType.class) {
            return;
        }
        if (fieldType == Date.class) {
            td.setDate((Date)pair.getValue());
        } else if (fieldType == LocalDateTime.class) {
            td.setLocalDateTime((LocalDateTime)pair.getValue());
        } else if (fieldType == LocalDate.class) {
            td.setLocalDate((LocalDate)pair.getValue());
        } else if (File.class.isAssignableFrom(fieldType)) {
            td.setFile((java.io.File)pair.getValue());
        } else {
            td.setContent(String.valueOf(pair.getValue()));
        }
    }

    private void setTdContentType(Td td, Class fieldType) {
        if (String.class == fieldType) {
            return;
        }
        if (ReflectUtil.isNumber(fieldType)) {
            td.setTdContentType(ContentTypeEnum.DOUBLE);
            return;
        }
        if (ReflectUtil.isDate(fieldType)) {
            td.setTdContentType(ContentTypeEnum.DATE);
            return;
        }
        if (ReflectUtil.isBool(fieldType)) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN);
            return;
        }
        if (fieldType == DropDownList.class) {
            td.setTdContentType(ContentTypeEnum.DROP_DOWN_LIST);
            return;
        }
        if (fieldType == NumberDropDownList.class) {
            td.setTdContentType(ContentTypeEnum.NUMBER_DROP_DOWN_LIST);
            return;
        }
        if (fieldType == BooleanDropDownList.class) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN_DROP_DOWN_LIST);
            return;
        }
        if (td.getContent() != null && fieldType == LinkUrl.class) {
            td.setTdContentType(ContentTypeEnum.LINK_URL);
            this.setLinkTd(td);
            return;
        }
        if (td.getContent() != null && fieldType == LinkEmail.class) {
            td.setTdContentType(ContentTypeEnum.LINK_EMAIL);
            this.setLinkTd(td);
            return;
        }
        if (td.getFile() != null && fieldType == ImageFile.class) {
            td.setTdContentType(ContentTypeEnum.IMAGE);
        }
    }

    private void setLinkTd(Td td) {
        String[] splits = td.getContent().split("->");
        if (splits.length == 1) {
            td.setLink(td.getContent());
        } else {
            td.setContent(splits[0]);
            td.setLink(splits[1]);
        }
    }

    protected void setTitles(List<String> titles) {
        boolean hasTitle;
        if (this.titles == null && (hasTitle = titles.stream().anyMatch(StringUtil::isNotBlank))) {
            this.titles = titles;
        }
    }

    protected List<Field> getGroupFields(List<Field> preElectionFields, Class<?>[] groups) {
        List selectedGroupList = Objects.nonNull(groups) ? Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        return preElectionFields.stream().filter(field -> !field.isAnnotationPresent(ExcludeColumn.class) && !field.isAnnotationPresent(IgnoreColumn.class) && ReflectUtil.isFieldSelected(selectedGroupList, field)).sorted(ReflectUtil::sortFields).collect(Collectors.toList());
    }

    protected List<Field> getPreElectionFields(ClassFieldContainer classFieldContainer) {
        if (Objects.nonNull(this.fieldDisplayOrder) && !this.fieldDisplayOrder.isEmpty()) {
            this.selfAdaption();
            return this.fieldDisplayOrder.stream().map(classFieldContainer::getFieldByName).collect(Collectors.toList());
        }
        List<Object> preElectionFields = this.configuration.isIncludeAllField() ? (this.configuration.isExcludeParent() ? classFieldContainer.getDeclaredFields() : classFieldContainer.getFields()) : (this.configuration.isExcludeParent() ? classFieldContainer.getDeclaredFields().stream().filter(field -> field.isAnnotationPresent(ExcelColumn.class)).collect(Collectors.toList()) : classFieldContainer.getFieldsByAnnotation(ExcelColumn.class));
        if (this.configuration.isIgnoreStaticFields()) {
            preElectionFields = preElectionFields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        }
        return preElectionFields;
    }

    private void selfAdaption() {
        if (this.titles == null || this.titles.isEmpty()) {
            return;
        }
        if (this.fieldDisplayOrder.size() > this.titles.size()) {
            int size = this.fieldDisplayOrder.size() - this.titles.size();
            for (int i = 0; i < size; ++i) {
                this.titles.add(null);
            }
        }
    }

    protected <T> List<Pair<? extends Class, ?>> getRenderContent(T data, List<Field> sortedFields) {
        return sortedFields.stream().map(field -> {
            Pair<? extends Class, Object> value = WriteConverterContext.convert(field, data, this.convertContext);
            if (value.getValue() != null) {
                return value;
            }
            String defaultValue = this.defaultValueMap.get(field);
            if (defaultValue != null) {
                return Pair.of(String.class, defaultValue);
            }
            if (this.configuration.getDefaultValue() != null) {
                return Pair.of(String.class, this.configuration.getDefaultValue());
            }
            return value;
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    protected List<Pair<? extends Class, ?>> assemblingMapContents(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList contents = new ArrayList(data.size());
        if (this.fieldDisplayOrder == null) {
            data.forEach((k, v) -> contents.add(Pair.of(v == null ? NullType.class : v.getClass(), v)));
        } else {
            for (String fieldName : this.fieldDisplayOrder) {
                Object val = data.get(fieldName);
                contents.add(Pair.of(val == null ? NullType.class : val.getClass(), val));
            }
        }
        return contents;
    }
}

