/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.serde;

import com.github.housepower.jdbc.buffer.BuffedReader;
import com.github.housepower.jdbc.buffer.CompressedBuffedReader;
import com.github.housepower.jdbc.misc.Either;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BinaryDeserializer {
    private final Either<BuffedReader> either;

    public BinaryDeserializer(BuffedReader buffedReader) {
        this.either = new Either<CompressedBuffedReader>((CompressedBuffedReader)buffedReader, new CompressedBuffedReader(buffedReader));
    }

    public long readVarInt() throws IOException {
        int number = 0;
        for (int i = 0; i < 9; ++i) {
            int byt = this.either.get().readBinary();
            number |= (byt & 0x7F) << 7 * i;
            if ((byt & 0x80) == 0) break;
        }
        return number;
    }

    public short readShort() throws IOException {
        return (short)(((this.either.get().readBinary() & 0xFF) << 0) + ((this.either.get().readBinary() & 0xFF) << 8));
    }

    public int readInt() throws IOException {
        return ((this.either.get().readBinary() & 0xFF) << 0) + ((this.either.get().readBinary() & 0xFF) << 8) + ((this.either.get().readBinary() & 0xFF) << 16) + ((this.either.get().readBinary() & 0xFF) << 24);
    }

    public long readLong() throws IOException {
        return (((long)this.either.get().readBinary() & 0xFFL) << 0) + (((long)this.either.get().readBinary() & 0xFFL) << 8) + (((long)this.either.get().readBinary() & 0xFFL) << 16) + (((long)this.either.get().readBinary() & 0xFFL) << 24) + (((long)this.either.get().readBinary() & 0xFFL) << 32) + (((long)this.either.get().readBinary() & 0xFFL) << 40) + (((long)this.either.get().readBinary() & 0xFFL) << 48) + (((long)this.either.get().readBinary() & 0xFFL) << 56);
    }

    public boolean readBoolean() throws IOException {
        return this.either.get().readBinary() != 0;
    }

    public byte[] readBytesBinary() throws IOException {
        byte[] data = new byte[(int)this.readVarInt()];
        this.either.get().readBinary(data);
        return data;
    }

    public String readUTF8StringBinary() throws IOException {
        byte[] data = new byte[(int)this.readVarInt()];
        return this.either.get().readBinary(data) > 0 ? new String(data, StandardCharsets.UTF_8) : "";
    }

    public byte readByte() throws IOException {
        return (byte)this.either.get().readBinary();
    }

    public void maybeEnableCompressed() {
        this.either.select(true);
    }

    public void maybeDisableCompressed() {
        this.either.select(false);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(((this.either.get().readBinary() & 0xFF) << 0) + ((this.either.get().readBinary() & 0xFF) << 8) + ((this.either.get().readBinary() & 0xFF) << 16) + (this.either.get().readBinary() << 24));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble((((long)this.either.get().readBinary() & 0xFFL) << 0) + (((long)this.either.get().readBinary() & 0xFFL) << 8) + (((long)this.either.get().readBinary() & 0xFFL) << 16) + (((long)this.either.get().readBinary() & 0xFFL) << 24) + (((long)this.either.get().readBinary() & 0xFFL) << 32) + (((long)this.either.get().readBinary() & 0xFFL) << 40) + (((long)this.either.get().readBinary() & 0xFFL) << 48) + (((long)this.either.get().readBinary() & 0xFFL) << 56));
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.either.get().readBinary(bytes);
        return bytes;
    }
}

