/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeCreator;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.serde.BinaryDeserializer;
import com.github.housepower.jdbc.serde.BinarySerializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class DataTypeString
implements IDataType {
    public static DataTypeCreator CREATOR = (lexer, serverContext) -> new DataTypeString(serverContext);
    private final Charset charset;

    public DataTypeString(NativeContext.ServerContext serverContext) {
        this.charset = serverContext.getConfigure().charset();
    }

    @Override
    public String name() {
        return "String";
    }

    @Override
    public int sqlTypeId() {
        return 12;
    }

    @Override
    public Object defaultValue() {
        return "";
    }

    @Override
    public Class javaType() {
        return String.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        if (data instanceof CharSequence) {
            serializer.writeStringBinary(data.toString(), this.charset);
        } else {
            serializer.writeBytesBinary((byte[])data);
        }
    }

    @Override
    public String deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        byte[] bs = deserializer.readBytesBinary();
        return new String(bs, this.charset);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] data = new String[rows];
        for (int row = 0; row < rows; ++row) {
            byte[] bs = deserializer.readBytesBinary();
            data[row] = new String(bs, this.charset);
        }
        return data;
    }

    @Override
    public String[] getAliases() {
        return new String[]{"LONGBLOB", "MEDIUMBLOB", "TINYBLOB", "MEDIUMTEXT", "CHAR", "VARCHAR", "TEXT", "TINYTEXT", "LONGTEXT", "BLOB"};
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        return lexer.stringView();
    }
}

