/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeCreator;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serde.BinaryDeserializer;
import com.github.housepower.jdbc.serde.BinarySerializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class DataTypeFixedString
implements IDataType {
    public static DataTypeCreator creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        Number fixedStringN = lexer.numberLiteral();
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeFixedString("FixedString(" + fixedStringN.intValue() + ")", fixedStringN.intValue(), serverContext);
    };
    private final int n;
    private final String name;
    private final String defaultValue;
    private final Charset charset;

    public DataTypeFixedString(String name, int n, NativeContext.ServerContext serverContext) {
        this.n = n;
        this.name = name;
        this.charset = serverContext.getConfigure().charset();
        byte[] data = new byte[n];
        for (int i = 0; i < n; ++i) {
            data[i] = 0;
        }
        this.defaultValue = new String(data, this.charset);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 12;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class javaType() {
        return String.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return this.n;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        return lexer.stringLiteral();
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        if (data instanceof String) {
            this.writeBytes(((String)data).getBytes(this.charset), serializer);
        } else {
            this.writeBytes((byte[])data, serializer);
        }
    }

    private void writeBytes(byte[] bs, BinarySerializer serializer) throws IOException, SQLException {
        byte[] res;
        if (bs.length > this.n) {
            throw new SQLException("The size of FixString column is too large, got " + bs.length);
        }
        if (bs.length == this.n) {
            res = bs;
        } else {
            res = new byte[this.n];
            System.arraycopy(bs, 0, res, 0, bs.length);
        }
        serializer.writeBytes(res);
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return new String(deserializer.readBytes(this.n), this.charset);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] data = new String[rows];
        for (int row = 0; row < rows; ++row) {
            data[row] = new String(deserializer.readBytes(this.n), this.charset);
        }
        return data;
    }

    @Override
    public String[] getAliases() {
        return new String[]{"BINARY"};
    }
}

