/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.data.AbstractColumn;
import com.github.housepower.jdbc.data.ColumnFactory;
import com.github.housepower.jdbc.data.ColumnWriterBuffer;
import com.github.housepower.jdbc.data.IColumn;
import com.github.housepower.jdbc.data.type.complex.DataTypeNullable;
import com.github.housepower.jdbc.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ColumnNullable
extends AbstractColumn {
    private final List<Byte> nullableSign = new ArrayList<Byte>();
    private final IColumn data;

    public ColumnNullable(String name, DataTypeNullable type, Object[] values) {
        super(name, type, values);
        this.data = ColumnFactory.createColumn(null, type.getNestedDataType(), null);
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        this.nullableSign.add(object == null ? (byte)1 : 0);
        this.data.write(object == null ? this.type.defaultValue() : object);
    }

    @Override
    public void flushToSerializer(BinarySerializer serializer, boolean immediate) throws IOException, SQLException {
        if (this.isExported()) {
            serializer.writeUTF8StringBinary(this.name);
            serializer.writeUTF8StringBinary(this.type.name());
        }
        for (byte sign : this.nullableSign) {
            serializer.writeByte(sign);
        }
        if (immediate) {
            this.buffer.writeTo(serializer);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        this.data.setColumnWriterBuffer(buffer);
    }
}

