/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.data.AbstractColumn;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class Column
extends AbstractColumn {
    public Column(String name, IDataType type, Object[] values) {
        super(name, type, values);
        this.values = values;
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        this.type().serializeBinary(object, this.buffer.column);
    }

    @Override
    public void flushToSerializer(BinarySerializer serializer, boolean now) throws IOException, SQLException {
        if (this.isExported()) {
            serializer.writeUTF8StringBinary(this.name);
            serializer.writeUTF8StringBinary(this.type.name());
        }
        if (now) {
            this.buffer.writeTo(serializer);
        }
    }
}

