/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.data.BlockSettings;
import com.github.housepower.jdbc.data.ColumnFactory;
import com.github.housepower.jdbc.data.ColumnWriterBuffer;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IColumn;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serde.BinaryDeserializer;
import com.github.housepower.jdbc.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Block {
    private final IColumn[] columns;
    private final BlockSettings settings;
    private final Map<String, Integer> nameAndPositions;
    private final Object[] rowData;
    private final int[] placeholderIndexes;
    private int rowCnt;

    public static Block readFrom(BinaryDeserializer deserializer, NativeContext.ServerContext serverContext) throws IOException, SQLException {
        BlockSettings info = BlockSettings.readFrom(deserializer);
        int columnCnt = (int)deserializer.readVarInt();
        int rowCnt = (int)deserializer.readVarInt();
        IColumn[] columns = new IColumn[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            String name = deserializer.readUTF8StringBinary();
            String type = deserializer.readUTF8StringBinary();
            IDataType dataType = DataTypeFactory.get(type, serverContext);
            Object[] arr = dataType.deserializeBinaryBulk(rowCnt, deserializer);
            columns[i] = ColumnFactory.createColumn(name, dataType, arr);
        }
        return new Block(rowCnt, columns, info);
    }

    public Block() {
        this(0, new IColumn[0]);
    }

    public Block(int rowCnt, IColumn[] columns) {
        this(rowCnt, columns, new BlockSettings(BlockSettings.Setting.defaultValues()));
    }

    public Block(int rowCnt, IColumn[] columns, BlockSettings settings) {
        this.rowCnt = rowCnt;
        this.columns = columns;
        this.settings = settings;
        this.rowData = new Object[columns.length];
        this.nameAndPositions = new HashMap<String, Integer>();
        this.placeholderIndexes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.nameAndPositions.put(columns[i].name(), i + 1);
            this.placeholderIndexes[i] = i;
        }
    }

    public int rowCnt() {
        return this.rowCnt;
    }

    public int columnCnt() {
        return this.columns.length;
    }

    public void appendRow() throws SQLException {
        int i;
        try {
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].write(this.rowData[i]);
            }
            ++this.rowCnt;
        }
        catch (IOException | ClassCastException e) {
            throw new SQLException("Exception processing value " + this.rowData[i] + " for column: " + this.columns[i].name(), e);
        }
    }

    public void setConstObject(int columnIdx, Object object) {
        this.rowData[columnIdx] = object;
    }

    public void setPlaceholderObject(int placeholderIdx, Object object) {
        this.rowData[this.placeholderIndexes[placeholderIdx]] = object;
    }

    public void incPlaceholderIndexes(int columnIdx) {
        int i = columnIdx;
        while (i < this.placeholderIndexes.length) {
            int n = i++;
            this.placeholderIndexes[n] = this.placeholderIndexes[n] + 1;
        }
    }

    public void writeTo(BinarySerializer serializer) throws IOException, SQLException {
        this.settings.writeTo(serializer);
        serializer.writeVarInt(this.columns.length);
        serializer.writeVarInt(this.rowCnt);
        for (IColumn column : this.columns) {
            column.flushToSerializer(serializer, true);
        }
    }

    public IColumn getColumnByPosition(int position) throws SQLException {
        Validate.isTrue(position < this.columns.length, "Position " + position + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.columns[position];
    }

    public int getPositionByName(String columnName) throws SQLException {
        Validate.isTrue(this.nameAndPositions.containsKey(columnName), "Column '" + columnName + "' does not exist");
        return this.nameAndPositions.get(columnName);
    }

    public Object getObject(int columnIndex) throws SQLException {
        Validate.isTrue(columnIndex < this.columns.length, "Position " + columnIndex + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.rowData[columnIndex];
    }

    public void initWriteBuffer() {
        for (IColumn column : this.columns) {
            column.setColumnWriterBuffer(new ColumnWriterBuffer());
        }
    }
}

