/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeNullable;
import com.github.housepower.jdbc.log.Logger;
import com.github.housepower.jdbc.log.LoggerFactory;
import com.github.housepower.jdbc.wrapper.SQLResultSetMetaData;
import java.sql.SQLException;

public class ClickHouseResultSetMetaData
implements SQLResultSetMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseResultSetMetaData.class);
    private final Block header;
    private final String db;
    private final String table;

    public ClickHouseResultSetMetaData(Block header, String db, String table) {
        this.header = header;
        this.db = db;
        this.table = table;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.header.columnCnt();
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        IDataType type = this.header.getColumnByPosition(index - 1).type();
        return type.sqlTypeId();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 80;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.header.getColumnByPosition(column - 1).type().name();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.header.getColumnByPosition(column - 1).type().jdbcJavaType().getName();
    }

    @Override
    public String getColumnName(int index) throws SQLException {
        return this.getColumnLabel(index);
    }

    @Override
    public String getColumnLabel(int index) throws SQLException {
        return this.header.getColumnByPosition(index - 1).name();
    }

    @Override
    public int isNullable(int index) throws SQLException {
        return this.header.getColumnByPosition(index - 1).type() instanceof DataTypeNullable ? 1 : 0;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.header.getColumnByPosition(index - 1).type().isSigned();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.header.getColumnByPosition(column - 1).type().getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.header.getColumnByPosition(column - 1).type().getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.table;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "default";
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.db;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("Unable to unwrap to " + iface.toString());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isReadOnly(int index) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int index) throws SQLException {
        return false;
    }

    @Override
    public boolean isAutoIncrement(int index) throws SQLException {
        return false;
    }

    @Override
    public Logger logger() {
        return LOG;
    }
}

