/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.jdbc.ClickHouseResultSet;
import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.settings.ClickHouseConfig;
import com.github.housepower.jdbc.stream.QueryResult;
import com.github.housepower.jdbc.stream.QueryResultBuilder;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class ClickHouseResultSetBuilder {
    private final QueryResultBuilder queryResultBuilder;
    private ClickHouseConfig cfg;
    private String db = "default";
    private String table = "unknown";

    public static ClickHouseResultSetBuilder builder(int columnsNum, NativeContext.ServerContext serverContext) {
        return new ClickHouseResultSetBuilder(QueryResultBuilder.builder(columnsNum, serverContext));
    }

    private ClickHouseResultSetBuilder(QueryResultBuilder queryResultBuilder) {
        this.queryResultBuilder = queryResultBuilder;
    }

    public ClickHouseResultSetBuilder cfg(ClickHouseConfig cfg) {
        this.cfg = cfg;
        return this;
    }

    public ClickHouseResultSetBuilder db(String db) {
        this.db = db;
        return this;
    }

    public ClickHouseResultSetBuilder table(String table) {
        this.table = table;
        return this;
    }

    public ClickHouseResultSetBuilder columnNames(String ... names) {
        return this.columnNames(Arrays.asList(names));
    }

    public ClickHouseResultSetBuilder columnNames(List<String> names) {
        this.queryResultBuilder.columnNames(names);
        return this;
    }

    public ClickHouseResultSetBuilder columnTypes(String ... types) throws SQLException {
        return this.columnTypes(Arrays.asList(types));
    }

    public ClickHouseResultSetBuilder columnTypes(List<String> types) throws SQLException {
        this.queryResultBuilder.columnTypes(types);
        return this;
    }

    public ClickHouseResultSetBuilder addRow(Object ... row) {
        return this.addRow(Arrays.asList(row));
    }

    public ClickHouseResultSetBuilder addRow(List<?> row) {
        this.queryResultBuilder.addRow(row);
        return this;
    }

    public ClickHouseResultSet build() throws SQLException {
        Validate.ensure(this.cfg != null);
        QueryResult queryResult = this.queryResultBuilder.build();
        return new ClickHouseResultSet(null, this.cfg, this.db, this.table, queryResult.header(), queryResult.data());
    }
}

