package com.github.houbb.segment.constant.enums;

/**
 * 分词类型枚举
 * @author binbin.hou
 * @since 0.0.1
 */
public enum WordTypeEnum {
    /**
     * 形容词性语素。形容词代码为a，语素代码ｇ前面置以A。
     */
    AG("Ag", "形语素"),
    /**
     * 取英语形容词adjective的第1个字母。
     */
    A("a", "形容词"),
    /**
     * 直接作状语的形容词。形容词代码a和副词代码d并在一起。
     */
    AD("ad", "副形词"),
    /**
     * 具有名词功能的形容词。形容词代码a和名词代码n并在一起。
     */
    AN("an", "名形词"),
    /**
     * 取汉字“别”的声母。
     */
    B("b", "区别词"),
    /**
     * 取英语连词conjunction的第1个字母。
     */
    C("c", "连词"),
    /**
     * 副词性语素。副词代码为d，语素代码ｇ前面置以D。
     */
    DG("dg", "副语素"),
    /**
     * 取adverb的第2个字母，因其第1个字母已用于形容词。
     */
    D("d", "副词"),
    /**
     * 取英语叹词exclamation的第1个字母。
     */
    E("e", "叹词"),
    /**
     * 取汉字“方”
     */
    F("f", "方位词"),
    /**
     * 绝大多数语素都能作为合成词的“词根”，取汉字“根”的声母。
     */
    G("g", "语素"),
    /**
     * 取英语head的第1个字母。
     */
    H("h", "前接成分"),
    /**
     * 取英语成语idiom的第1个字母。
     */
    I("i", "成语"),
    /**
     * 取汉字“简”的声母。
     */
    J("j", "简称略语"),
    /**
     * 后接成分
     */
    K("k", "后接成分"),
    /**
     * 习用语尚未成为成语，有点“临时性”，取“临”的声母。
     */
    L("l", "习用语"),
    /**
     * 取英语
     */
    M("m", "数词"),
    /**
     * 名词性语素。名词代码为n，语素代码ｇ前面置以N。
     */
    NG("Ng", "名语素"),
    /**
     * 取英语名词noun的第1个字母。
     */
    N("n", "名词"),
    /**
     * 名词代码n和“人(ren)”的声母并在一起。
     */
    NR("nr", "人名"),
    /**
     * 名词代码n和处所词代码s并在一起。
     */
    NS("ns", "地名"),
    /**
     * “团”的声母为t，名词代码n和t并在一起。
     */
    NT("nt", "机构团体"),
    /**
     * “专”的声母的第1个字母为z，名词代码n和z并在一起。
     */
    NZ("nz", "其他专名"),
    /**
     * 取英语拟声词onomatopoeia的第1个字母。
     */
    O("o", "拟声词"),
    /**
     * 取英语介词prepositional的第1个字母。
     */
    P("p", "介词"),
    /**
     * 取英语quantity的第1个字母。
     */
    Q("q", "量词"),
    /**
     * 取英语代词pronoun的第2个字母,因p已用于介词。
     */
    R("r", "代词"),
    /**
     * 取英语space的第1个字母。
     */
    S("s", "处所词"),
    /**
     * 时间词性语素。时间词代码为t,在语素的代码g前面置以T。
     */
    TG("tg", "时语素"),
    /**
     * 取英语time的第1个字母。
     */
    T("t", "时间词"),
    /**
     * 取英语助词auxiliary
     */
    U("u", "助词"),
    /**
     * 动词性语素。动词代码为v。在语素的代码g前面置以V。
     */
    VG("vg", "动语素"),
    /**
     * 取英语动词verb的第一个字母。
     */
    V("v", "动词"),
    /**
     * 直接作状语的动词。动词和副词的代码并在一起。
     */
    VD("vd", "副动词"),
    /**
     * 指具有名词功能的动词。动词和名词的代码并在一起。
     */
    VN("vn", "名动词"),
    /**
     * 标点符号
     */
    W("w", "标点符号"),
    /**
     * 非语素字只是一个符号，字母x通常用于代表未知数、符号。
     */
    X("x", "非语素字"),
    /**
     * 取汉字“语”的声母。
     */
    Y("y", "语气词"),
    /**
     * 取汉字“状”的声母的前一个字母。
     */
    Z("z", "状态词"),
    /**
     * 不可识别词及用户自定义词组。取英文un-known首两个字母。(非北大标准，CSW分词中定义)
     */
    UN("un", "未知词"),
    ;

    /**
     * 编码
     * @since 0.0.1
     */
    private final String code;

    /**
     * 描述
     * @since 0.0.1
     */
    private final String desc;

    WordTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }
}
