/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.stdout;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.log.integration.constant.Level;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StdOutExImpl
implements Log {
    private String clazz;

    public StdOutExImpl(String clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return false;
    }

    @Override
    public boolean isFatalEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }

    @Override
    public void fatal(String s, Throwable e) {
        this.log(Level.FATAL, s, e);
    }

    @Override
    public void fatal(String s) {
        this.log(Level.FATAL, s, null);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log(Level.ERROR, s, e);
    }

    @Override
    public void error(String s) {
        this.log(Level.ERROR, s, null);
    }

    @Override
    public void debug(String s) {
        this.log(Level.DEBUG, s, null);
    }

    @Override
    public void trace(String s) {
        this.log(Level.TRACE, s, null);
    }

    @Override
    public void warn(String s) {
        this.log(Level.WARN, s, null);
    }

    @Override
    public void info(String s) {
        this.log(Level.INFO, s, null);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        this.log(Level.FATAL, LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void fatal(String s, Object ... params) {
        this.log(Level.FATAL, LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log(Level.ERROR, LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log(Level.ERROR, LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log(Level.DEBUG, LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log(Level.TRACE, LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log(Level.WARN, LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void info(String s, Object ... params) {
        this.log(Level.INFO, LogUtil.getLogInfo(s, params), null);
    }

    private void log(Level level, String content, Throwable throwable) {
        StackTraceElement callMethodElem = Thread.currentThread().getStackTrace()[3];
        String className = this.clazz;
        String methodNameName = callMethodElem.getMethodName();
        String prettyMethod = this.buildPrettyMethodName(className, methodNameName);
        String threadName = Thread.currentThread().getName();
        String dateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
        String log = String.format("[%s] [%s] [%s] [%s] - %s", level, dateStr, threadName, prettyMethod, content);
        if (level.isLessSpecificThan(Level.ERROR) && level.isMoreSpecificThan(Level.OFF)) {
            System.err.println(log);
        } else {
            System.out.println(log);
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    private String buildPrettyMethodName(String className, String methodName) {
        Object[] classNames = className.split("\\.");
        if (ArrayUtil.isEmpty((Object[])classNames)) {
            return methodName;
        }
        int length = classNames.length;
        if (length == 1) {
            return className + "." + methodName;
        }
        List classFirstChars = Guavas.newArrayList((int)length);
        for (int i = 0; i < length - 1; ++i) {
            Object name = classNames[i];
            classFirstChars.add(String.valueOf(((String)name).charAt(0)));
        }
        classFirstChars.add(classNames[length - 1]);
        String prettyClass = CollectionUtil.join((Collection)classFirstChars, (String)".");
        return prettyClass + "." + methodName;
    }
}

