/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.log4j2;

import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.LogUtil;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Log4j2LoggerImpl
implements Log {
    private static Marker MARKER = MarkerManager.getMarker((String)"LOG-INTEGRATION");
    private Logger log;

    public Log4j2LoggerImpl(Logger logger) {
        this.log = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public void fatal(String s, Throwable e) {
        this.log.fatal(s, e);
    }

    @Override
    public void fatal(String s) {
        this.log.fatal(s);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.error(MARKER, s, e);
    }

    @Override
    public void error(String s) {
        this.log.error(MARKER, s);
    }

    @Override
    public void debug(String s) {
        this.log.debug(MARKER, s);
    }

    @Override
    public void trace(String s) {
        this.log.trace(MARKER, s);
    }

    @Override
    public void warn(String s) {
        this.log.warn(MARKER, s);
    }

    @Override
    public void info(String s) {
        this.log.info(s);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        this.log.fatal(LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void fatal(String s, Object ... params) {
        this.log.fatal(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log.error(MARKER, LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log.error(MARKER, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log.debug(MARKER, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log.trace(MARKER, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log.warn(MARKER, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void info(String s, Object ... params) {
        this.log.info(LogUtil.getLogInfo(s, params));
    }
}

