/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.log4j;

import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jImpl
implements Log {
    private static final String FQCN = Log4jImpl.class.getName();
    private Logger log;

    public Log4jImpl(String clazz) {
        this.log = Logger.getLogger((String)clazz);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isEnabledFor((Priority)Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void fatal(String s, Throwable e) {
        this.log.log(FQCN, (Priority)Level.FATAL, (Object)s, e);
    }

    @Override
    public void fatal(String s) {
        this.log.log(FQCN, (Priority)Level.FATAL, (Object)s, null);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.log(FQCN, (Priority)Level.ERROR, (Object)s, e);
    }

    @Override
    public void error(String s) {
        this.log.log(FQCN, (Priority)Level.ERROR, (Object)s, null);
    }

    @Override
    public void debug(String s) {
        this.log.log(FQCN, (Priority)Level.DEBUG, (Object)s, null);
    }

    @Override
    public void trace(String s) {
        this.log.log(FQCN, (Priority)Level.TRACE, (Object)s, null);
    }

    @Override
    public void warn(String s) {
        this.log.log(FQCN, (Priority)Level.WARN, (Object)s, null);
    }

    @Override
    public void info(String s) {
        this.log.log(FQCN, (Priority)Level.INFO, (Object)s, null);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        this.log.log(FQCN, (Priority)Level.FATAL, (Object)LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void fatal(String s, Object ... params) {
        this.log.log(FQCN, (Priority)Level.FATAL, (Object)LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log.log(FQCN, (Priority)Level.ERROR, (Object)LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log.log(FQCN, (Priority)Level.ERROR, (Object)LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log.log(FQCN, (Priority)Level.DEBUG, (Object)LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log.log(FQCN, (Priority)Level.TRACE, (Object)LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log.log(FQCN, (Priority)Level.WARN, (Object)LogUtil.getLogInfo(s, params), null);
    }

    @Override
    public void info(String s, Object ... params) {
        this.log.log(FQCN, (Priority)Level.INFO, (Object)LogUtil.getLogInfo(s, params), null);
    }
}

