/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.bean.mapping.asm.support.cache;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.github.houbb.heaven.support.cache.ICache;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodAccessCache
implements ICache<Class, MethodAccess> {
    private static final MethodAccessCache INSTANCE = new MethodAccessCache();
    private static final Map<Class, MethodAccess> ACCESS_MAP = new ConcurrentHashMap<Class, MethodAccess>();

    public static MethodAccessCache getInstance() {
        return INSTANCE;
    }

    public MethodAccess get(Class aClass) {
        MethodAccess methodAccess = ACCESS_MAP.get(aClass);
        if (ObjectUtil.isNotNull((Object)methodAccess)) {
            return methodAccess;
        }
        methodAccess = MethodAccess.get((Class)aClass);
        this.set(aClass, methodAccess);
        return methodAccess;
    }

    public void set(Class aClass, MethodAccess methodAccess) {
        ACCESS_MAP.put(aClass, methodAccess);
    }
}

