/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.bean.mapping.asm.api;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.github.houbb.bean.mapping.api.core.IBeanMpping;
import com.github.houbb.bean.mapping.asm.support.cache.MethodAccessCache;
import com.github.houbb.heaven.support.cache.impl.PropertyDescriptorListCache;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class AsmBeanMapping
implements IBeanMpping {
    public void mapping(Object source, Object target) {
        ArgUtil.notNull((Object)source, (String)"Source not allow null here.");
        ArgUtil.notNull((Object)target, (String)"Target not allow null here.");
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        MethodAccess sourceMethodAccess = MethodAccessCache.getInstance().get(sourceClass);
        MethodAccess targetMethodAccess = MethodAccessCache.getInstance().get(targetClass);
        List targetPropertyDescriptors = PropertyDescriptorListCache.getInstance().get(targetClass);
        Map sourceReadMethodMap = PropertyDescriptorListCache.getInstance().getReadMethodMap(sourceClass);
        for (PropertyDescriptor targetPd : targetPropertyDescriptors) {
            String propertyName = targetPd.getName();
            Method readMethod = (Method)sourceReadMethodMap.get(propertyName);
            if (!ObjectUtil.isNotNull((Object)readMethod)) continue;
            Method writeMethod = targetPd.getWriteMethod();
            if (!AsmBeanMapping.isPublicOrAccess(readMethod) || !AsmBeanMapping.isPublicOrAccess(writeMethod)) continue;
            String writeMethodName = writeMethod.getName();
            String readMethodName = readMethod.getName();
            int writeMethodIndex = sourceMethodAccess.getIndex(readMethodName);
            int readMethodIndex = targetMethodAccess.getIndex(writeMethodName);
            Object value = sourceMethodAccess.invoke(source, writeMethodIndex, new Object[0]);
            targetMethodAccess.invoke(target, readMethodIndex, new Object[]{value});
        }
    }

    private static boolean isPublicOrAccess(Method method) {
        if (method.isAccessible()) {
            return true;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    @Deprecated
    private Optional<Method> getReadMethodOpt(List<PropertyDescriptor> sourcePropertyDescriptors, PropertyDescriptor propertyDescriptor) {
        String name = propertyDescriptor.getName();
        for (PropertyDescriptor pd : sourcePropertyDescriptors) {
            if (!pd.getName().equals(name)) continue;
            return Optional.of((Object)pd.getReadMethod());
        }
        return Optional.empty();
    }
}

