/*
 * sitemesh2 (https://github.com/hazendaz/sitemesh2)
 *
 * Copyright 2011-2023 Hazendaz.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of The Apache Software License,
 * Version 2.0 which accompanies this distribution, and is available at
 * https://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Contributors:
 *     Hazendaz (Jeremy Landis).
 */
package com.opensymphony.module.sitemesh.html;

import com.opensymphony.module.sitemesh.SitemeshBuffer;
import com.opensymphony.module.sitemesh.SitemeshBufferFragment;

/**
 * The Interface HTMLProcessorContext.
 */
public interface HTMLProcessorContext {

    /**
     * Gets the sitemesh buffer.
     *
     * @return the sitemesh buffer
     */
    SitemeshBuffer getSitemeshBuffer();

    /**
     * Current state.
     *
     * @return the state
     */
    State currentState();

    /**
     * Change state.
     *
     * @param newState
     *            the new state
     */
    void changeState(State newState);

    /**
     * Push buffer.
     *
     * @param fragment
     *            the fragment
     */
    void pushBuffer(SitemeshBufferFragment.Builder fragment);

    /**
     * Current buffer.
     *
     * @return the sitemesh buffer fragment. builder
     */
    SitemeshBufferFragment.Builder currentBuffer();

    /**
     * Pop buffer.
     *
     * @return the sitemesh buffer fragment. builder
     */
    SitemeshBufferFragment.Builder popBuffer();
}
