/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smile.math.MathEx;
import smile.nlp.Corpus;
import smile.nlp.NlpKt;
import smile.nlp.SimpleCorpus;
import smile.nlp.Text;
import smile.nlp.collocation.Bigram;
import smile.nlp.collocation.NGram;
import smile.nlp.dictionary.EnglishPunctuations;
import smile.nlp.dictionary.EnglishStopWords;
import smile.nlp.dictionary.StopWords;
import smile.nlp.keyword.CooccurrenceKeywords;
import smile.nlp.normalizer.SimpleNormalizer;
import smile.nlp.pos.HMMPOSTagger;
import smile.nlp.pos.PennTreebankPOS;
import smile.nlp.stemmer.LancasterStemmer;
import smile.nlp.stemmer.PorterStemmer;
import smile.nlp.stemmer.Stemmer;
import smile.nlp.tokenizer.SimpleSentenceSplitter;
import smile.nlp.tokenizer.SimpleTokenizer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a/\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010\u001a/\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0012\u001a\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a.\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u00180\u000e\u001a\u000e\u0010\u0000\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f\u001a5\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00070\u00072\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u001d\u001a\u000e\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f\u001a\u001f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\u0002\u0010!\u001a&\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f\u001a\u001e\u0010\"\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020&0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020&0\u000e\u001a-\u0010(\u001a\u00020&2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u0018\u00a2\u0006\u0002\u0010)\u001a\"\u0010(\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0*\u001a,\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u0018*\u00020\u000f2\b\b\u0002\u0010+\u001a\u00020\u000f2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-\u001a&\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0**\u00020\u000f2\b\b\u0002\u0010+\u001a\u00020\u000f2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-\u001a\u001f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007*\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0002\u00100\u001a\n\u00101\u001a\u00020\u000f*\u00020\u000f\u001a\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007*\u00020\u000f\u00a2\u0006\u0002\u00102\u001a\u0015\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007*\u00020\u000f\u00a2\u0006\u0002\u00104\u001a\u001f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007*\u00020\u000f2\b\b\u0002\u0010+\u001a\u00020\u000f\u00a2\u0006\u0002\u00106\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"lancaster", "Lsmile/nlp/stemmer/LancasterStemmer;", "porter", "Lsmile/nlp/stemmer/PorterStemmer;", "tokenizer", "Lsmile/nlp/tokenizer/SimpleTokenizer;", "bigram", "", "Lsmile/nlp/collocation/Bigram;", "p", "", "minFreq", "", "text", "", "", "(DILjava/util/List;)[Lsmile/nlp/collocation/Bigram;", "k", "(IILjava/util/List;)[Lsmile/nlp/collocation/Bigram;", "corpus", "Lsmile/nlp/SimpleCorpus;", "df", "", "terms", "", "word", "ngram", "Lsmile/nlp/collocation/NGram;", "maxNGramSize", "(IILjava/util/List;)[[Lsmile/nlp/collocation/NGram;", "postag", "Lsmile/nlp/pos/PennTreebankPOS;", "sentence", "([Ljava/lang/String;)[Lsmile/nlp/pos/PennTreebankPOS;", "tfidf", "tf", "maxtf", "n", "", "bag", "vectorize", "([Ljava/lang/String;Ljava/util/Map;)[D", "", "filter", "stemmer", "Lsmile/nlp/stemmer/Stemmer;", "bag2", "keywords", "(Ljava/lang/String;I)[Lsmile/nlp/collocation/NGram;", "normalize", "(Ljava/lang/String;)[Lsmile/nlp/pos/PennTreebankPOS;", "sentences", "(Ljava/lang/String;)[Ljava/lang/String;", "words", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "smile-kotlin"})
@SourceDebugExtension(value={"SMAP\nnlp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nlp.kt\nsmile/nlp/NlpKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,377:1\n1855#2,2:378\n1360#2:380\n1446#2,2:381\n1448#2,3:393\n1559#2:400\n1590#2,4:401\n766#2:405\n857#2,2:406\n1549#2:408\n1620#2,3:409\n1549#2:412\n1620#2,2:413\n766#2:415\n857#2,2:416\n1622#2:418\n1855#2,2:419\n1549#2:421\n1620#2,3:422\n1360#2:430\n1446#2,5:431\n1549#2:436\n1620#2,3:437\n1549#2:440\n1620#2,3:441\n1477#2:444\n1502#2,3:445\n1505#2,3:455\n1238#2,4:460\n1360#2:464\n1446#2,5:465\n1549#2:470\n1620#2,3:471\n1549#2:474\n1620#2,3:475\n11335#3:383\n11670#3,2:384\n11335#3:386\n11670#3,3:387\n11672#3:392\n11335#3:396\n11670#3,3:397\n3792#3:425\n4307#3,2:426\n37#4,2:390\n37#4,2:428\n361#5,7:448\n442#5:458\n392#5:459\n*S KotlinDebug\n*F\n+ 1 nlp.kt\nsmile/nlp/NlpKt\n*L\n68#1:378,2\n117#1:380\n117#1:381,2\n117#1:393,3\n161#1:400\n161#1:401,4\n162#1:405\n162#1:406,2\n163#1:408\n163#1:409,3\n176#1:412\n176#1:413,2\n176#1:415\n176#1:416,2\n176#1:418\n202#1:419,2\n207#1:421\n207#1:422,3\n333#1:430\n333#1:431,5\n335#1:436\n335#1:437,3\n339#1:440\n339#1:441,3\n340#1:444\n340#1:445,3\n340#1:455,3\n341#1:460,4\n350#1:464\n350#1:465,5\n352#1:470\n352#1:471,3\n355#1:474\n355#1:475,3\n118#1:383\n118#1:384,2\n120#1:386\n120#1:387,3\n118#1:392\n147#1:396\n147#1:397,3\n320#1:425\n320#1:426,2\n121#1:390,2\n321#1:428,2\n340#1:448,7\n341#1:458\n341#1:459\n*E\n"})
public final class NlpKt {
    @NotNull
    private static final SimpleTokenizer tokenizer = new SimpleTokenizer(true);
    @NotNull
    private static final PorterStemmer porter = new PorterStemmer();
    @NotNull
    private static final LancasterStemmer lancaster = new LancasterStemmer();

    @NotNull
    public static final String porter(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = porter.stem(word);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"porter.stem(word)");
        return string;
    }

    @NotNull
    public static final String lancaster(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = lancaster.stem(word);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lancaster.stem(word)");
        return string;
    }

    @NotNull
    public static final SimpleCorpus corpus(@NotNull List<String> text) {
        SimpleCorpus simpleCorpus;
        Intrinsics.checkNotNullParameter(text, (String)"text");
        SimpleCorpus $this$corpus_u24lambda_u241 = simpleCorpus = new SimpleCorpus();
        boolean bl = false;
        Iterable $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String s = (String)element$iv;
            boolean bl2 = false;
            $this$corpus_u24lambda_u241.add(new Text(s));
        }
        return simpleCorpus;
    }

    @NotNull
    public static final Bigram[] bigram(int k, int minFreq, @NotNull List<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Bigram[] bigramArray = Bigram.of((Corpus)((Corpus)NlpKt.corpus(text)), (int)k, (int)minFreq);
        Intrinsics.checkNotNullExpressionValue((Object)bigramArray, (String)"of(corpus(text), k, minFreq)");
        return bigramArray;
    }

    @NotNull
    public static final Bigram[] bigram(double p, int minFreq, @NotNull List<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Bigram[] bigramArray = Bigram.of((Corpus)((Corpus)NlpKt.corpus(text)), (double)p, (int)minFreq);
        Intrinsics.checkNotNullExpressionValue((Object)bigramArray, (String)"of(corpus(text), p, minFreq)");
        return bigramArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final NGram[][] ngram(int maxNGramSize, int minFreq, @NotNull List<String> text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Iterable $this$flatMap$iv = text;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String doc = (String)element$iv$iv;
            boolean bl = false;
            String[] $this$map$iv = NlpKt.sentences(doc);
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv2;
                Collection $this$map$iv2;
                void sentence;
                void item$iv$iv;
                void var21_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String[] stringArray2 = NlpKt.words((String)sentence, "none");
                boolean $i$f$map2 = false;
                void var26_25 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(((void)$this$map$iv2).length);
                boolean $i$f$mapTo2 = false;
                int n2 = ((void)$this$mapTo$iv$iv2).length;
                for (int j = 0; j < n2; ++j) {
                    void word;
                    void item$iv$iv2;
                    void var32_31 = item$iv$iv2 = $this$mapTo$iv$iv2[j];
                    Collection collection2 = destination$iv$iv3;
                    boolean bl3 = false;
                    String string = porter.stripPluralParticiple((String)word);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"porter.stripPluralParticiple(word)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection2.add(string2);
                }
                $this$map$iv2 = (List)destination$iv$iv3;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                collection.add(thisCollection$iv.toArray(new String[0]));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List sentences = (List)destination$iv$iv;
        NGram[][] nGramArray = NGram.of((Collection)sentences, (int)maxNGramSize, (int)minFreq);
        Intrinsics.checkNotNullExpressionValue((Object)nGramArray, (String)"of(sentences, maxNGramSize, minFreq)");
        return nGramArray;
    }

    @NotNull
    public static final PennTreebankPOS[] postag(@NotNull String[] sentence) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        PennTreebankPOS[] pennTreebankPOSArray = HMMPOSTagger.getDefault().tag(sentence);
        Intrinsics.checkNotNullExpressionValue((Object)pennTreebankPOSArray, (String)"getDefault().tag(sentence)");
        return pennTreebankPOSArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] vectorize(@NotNull String[] terms, @NotNull Map<String, Integer> bag2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        Intrinsics.checkNotNullParameter(bag2, (String)"bag");
        String[] $this$map$iv = terms;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Double.valueOf(((Number)bag2.getOrDefault(it, 0)).intValue()));
        }
        return CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] vectorize(@NotNull List<String> terms, @NotNull Set<String> bag2) {
        void $this$mapTo$iv$iv;
        Pair pair;
        Iterable $this$filterTo$iv$iv;
        String term;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        Intrinsics.checkNotNullParameter(bag2, (String)"bag");
        Iterable $this$mapIndexed$iv = terms;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)((int)index), (Object)term));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapIndexedTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            term = (String)pair.component2();
            if (!bag2.contains(term)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int index = ((Number)pair.component1()).intValue();
            collection.add(index);
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] df(@NotNull List<String> terms, @NotNull List<? extends Map<String, Integer>> corpus) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        Intrinsics.checkNotNullParameter(corpus, (String)"corpus");
        Iterable $this$map$iv = terms;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = corpus;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void term;
                Map it = (Map)element$iv$iv;
                boolean bl2 = false;
                if (!it.containsKey(term)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collection.add(((List)destination$iv$iv2).size());
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    public static final double tfidf(double tf, double maxtf, int n, int df) {
        return tf / Math.max(1.0, maxtf) * Math.log10((1.0 + (double)n) / (1.0 + (double)df));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<double[]> tfidf(@NotNull List<double[]> corpus) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(corpus, (String)"corpus");
        int n = corpus.size();
        int[] df = new int[corpus.get(0).length];
        Iterable $this$forEach$iv = corpus;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double[] bag2 = (double[])element$iv;
            boolean bl = false;
            int n2 = df.length;
            for (int i = 0; i < n2; ++i) {
                if (!(bag2[i] > 0.0)) continue;
                df[i] = df[i] + 1;
            }
        }
        Iterable $this$map$iv = corpus;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bag3;
            double[] dArray = (double[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NlpKt.tfidf((double[])bag3, n, df));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final double[] tfidf(@NotNull double[] bag2, int n, @NotNull int[] df) {
        Intrinsics.checkNotNullParameter((Object)bag2, (String)"bag");
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Double d = ArraysKt.maxOrNull((double[])bag2);
        double maxtf = d != null ? d : 0.0;
        double[] features = new double[bag2.length];
        int n2 = features.length;
        for (int i = 0; i < n2; ++i) {
            features[i] = NlpKt.tfidf(bag2[i], maxtf, n, df[i]);
        }
        MathEx.unitize((double[])features);
        return features;
    }

    @NotNull
    public static final String normalize(@NotNull String $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        String string = SimpleNormalizer.getInstance().normalize($this$normalize);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().normalize(this)");
        return string;
    }

    @NotNull
    public static final String[] sentences(@NotNull String $this$sentences) {
        Intrinsics.checkNotNullParameter((Object)$this$sentences, (String)"<this>");
        String[] stringArray = SimpleSentenceSplitter.getInstance().split($this$sentences);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getInstance().split(this)");
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] words(@NotNull String $this$words, @NotNull String filter) {
        void $this$toTypedArray$iv;
        void $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        StopWords stopWords;
        Intrinsics.checkNotNullParameter((Object)$this$words, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        String[] tokens = tokenizer.split($this$words);
        if (Intrinsics.areEqual((Object)filter, (Object)"none")) {
            Intrinsics.checkNotNullExpressionValue((Object)tokens, (String)"tokens");
            return tokens;
        }
        switch (filter) {
            case "default": {
                stopWords = (StopWords)EnglishStopWords.DEFAULT;
                break;
            }
            case "comprehensive": {
                stopWords = (StopWords)EnglishStopWords.COMPREHENSIVE;
                break;
            }
            case "google": {
                stopWords = (StopWords)EnglishStopWords.GOOGLE;
                break;
            }
            case "mysql": {
                stopWords = (StopWords)EnglishStopWords.MYSQL;
                break;
            }
            default: {
                stopWords = new StopWords(filter){
                    @NotNull
                    private final Set<String> dict;
                    {
                        String[] stringArray = new String[]{","};
                        this.dict = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)$filter, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                    }

                    @NotNull
                    public final Set<String> getDict() {
                        return this.dict;
                    }

                    public boolean contains(@NotNull String word) {
                        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
                        return this.dict.contains(word);
                    }

                    public int size() {
                        return this.dict.size();
                    }

                    @NotNull
                    public Iterator<String> iterator() {
                        Iterator<String> iterator = this.dict.iterator();
                        Intrinsics.checkNotNull(iterator, (String)"null cannot be cast to non-null type kotlin.collections.MutableIterator<kotlin.String>");
                        return TypeIntrinsics.asMutableIterator(iterator);
                    }
                };
            }
        }
        StopWords dict2 = stopWords;
        EnglishPunctuations punctuations = EnglishPunctuations.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)tokens, (String)"tokens");
        String[] stringArray = tokens;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void word = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"word");
            String string = word.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!(!dict2.contains(string) && !punctuations.contains((String)word))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    public static /* synthetic */ String[] words$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "default";
        }
        return NlpKt.words(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Integer> bag(@NotNull String $this$bag, @NotNull String filter, @Nullable Stemmer stemmer) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        String p0;
        Object object;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Object list$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Iterable $this$flatMap$iv = ArraysKt.toList((Object[])NlpKt.sentences(NlpKt.normalize($this$bag)));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ArraysKt.toList((Object[])NlpKt.words(it, filter));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List words2 = (List)destination$iv$iv;
        if (stemmer != null) {
            $this$map$iv = words2;
            $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(stemmer.stem(p0));
            }
            words2 = (List)destination$iv$iv;
        }
        $this$map$iv = words2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = p0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            object.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (String)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl3 = false;
            List v = (List)entry.getValue();
            Integer n = v.size();
            object.put(k, n);
        }
        return MapsKt.withDefault((Map)destination$iv$iv, (Function1)bag.5.INSTANCE);
    }

    public static /* synthetic */ Map bag$default(String string, String string2, Stemmer stemmer, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "default";
        }
        if ((n & 2) != 0) {
            stemmer = (Stemmer)porter;
        }
        return NlpKt.bag(string, string2, stemmer);
    }

    @NotNull
    public static final Set<String> bag2(@NotNull String $this$bag2, @NotNull String filter, @Nullable Stemmer stemmer) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bag2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Iterable $this$flatMap$iv = ArraysKt.toList((Object[])NlpKt.sentences(NlpKt.normalize($this$bag2)));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ArraysKt.toList((Object[])NlpKt.words(it, filter));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List words2 = (List)destination$iv$iv;
        if (stemmer != null) {
            $this$map$iv = words2;
            $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(stemmer.stem(p0));
            }
            words2 = (List)destination$iv$iv;
        }
        $this$map$iv = words2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = p0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Set bag2$default(String string, String string2, Stemmer stemmer, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "default";
        }
        if ((n & 2) != 0) {
            stemmer = (Stemmer)porter;
        }
        return NlpKt.bag2(string, string2, stemmer);
    }

    @NotNull
    public static final PennTreebankPOS[] postag(@NotNull String $this$postag) {
        Intrinsics.checkNotNullParameter((Object)$this$postag, (String)"<this>");
        String[] words2 = NlpKt.words($this$postag, "none");
        PennTreebankPOS[] pennTreebankPOSArray = HMMPOSTagger.getDefault().tag(words2);
        Intrinsics.checkNotNullExpressionValue((Object)pennTreebankPOSArray, (String)"getDefault().tag(words)");
        return pennTreebankPOSArray;
    }

    @NotNull
    public static final NGram[] keywords(@NotNull String $this$keywords, int k) {
        Intrinsics.checkNotNullParameter((Object)$this$keywords, (String)"<this>");
        NGram[] nGramArray = CooccurrenceKeywords.of((String)$this$keywords, (int)k);
        Intrinsics.checkNotNullExpressionValue((Object)nGramArray, (String)"of(this, k)");
        return nGramArray;
    }

    public static /* synthetic */ NGram[] keywords$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return NlpKt.keywords(string, n);
    }
}

